/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String name) {
        this.fName = name;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult result2 = this.createResult();
        this.run(result2);
        return result2;
    }

    public void run(TestResult result2) {
        result2.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Throwable exception = null;
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable running) {
            exception = running;
        }
        finally {
            block13: {
                try {
                    this.tearDown();
                }
                catch (Throwable tearingDown) {
                    if (exception != null) break block13;
                    exception = tearingDown;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void runTest() throws Throwable {
        TestCase.assertNotNull("TestCase.fName cannot be null", this.fName);
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException e) {
            TestCase.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            TestCase.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
    }

    public static void assertTrue(String message2, boolean condition) {
        Assert.assertTrue(message2, condition);
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition);
    }

    public static void assertFalse(String message2, boolean condition) {
        Assert.assertFalse(message2, condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition);
    }

    public static void fail(String message2) {
        Assert.fail(message2);
    }

    public static void fail() {
        Assert.fail();
    }

    public static void assertEquals(String message2, Object expected, Object actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, String expected, String actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(String expected, String actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, double expected, double actual, double delta) {
        Assert.assertEquals(message2, expected, actual, delta);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(String message2, float expected, float actual, float delta) {
        Assert.assertEquals(message2, expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(String message2, long expected, long actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, boolean expected, boolean actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(boolean expected, boolean actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, byte expected, byte actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(byte expected, byte actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, char expected, char actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(char expected, char actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, short expected, short actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(short expected, short actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertEquals(String message2, int expected, int actual) {
        Assert.assertEquals(message2, expected, actual);
    }

    public static void assertEquals(int expected, int actual) {
        Assert.assertEquals(expected, actual);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object);
    }

    public static void assertNotNull(String message2, Object object) {
        Assert.assertNotNull(message2, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object);
    }

    public static void assertNull(String message2, Object object) {
        Assert.assertNull(message2, object);
    }

    public static void assertSame(String message2, Object expected, Object actual) {
        Assert.assertSame(message2, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(expected, actual);
    }

    public static void assertNotSame(String message2, Object expected, Object actual) {
        Assert.assertNotSame(message2, expected, actual);
    }

    public static void assertNotSame(Object expected, Object actual) {
        Assert.assertNotSame(expected, actual);
    }

    public static void failSame(String message2) {
        Assert.failSame(message2);
    }

    public static void failNotSame(String message2, Object expected, Object actual) {
        Assert.failNotSame(message2, expected, actual);
    }

    public static void failNotEquals(String message2, Object expected, Object actual) {
        Assert.failNotEquals(message2, expected, actual);
    }

    public static String format(String message2, Object expected, Object actual) {
        return Assert.format(message2, expected, actual);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }
}

