/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.advice.jvm;

import io.mockk.proxy.jvm.advice.BaseAdvice;
import io.mockk.proxy.jvm.advice.ProxyAdviceId;
import io.mockk.proxy.jvm.advice.jvm.MockHandlerMap;
import io.mockk.proxy.jvm.dispatcher.JvmMockKDispatcher;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;

public class JvmMockKStaticProxyAdvice
extends BaseAdvice {
    public JvmMockKStaticProxyAdvice(MockHandlerMap handlers) {
        super(handlers);
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enterStatic(@ProxyAdviceId long id, @Advice.Origin Method method2, @Advice.AllArguments Object[] arguments2) throws Throwable {
        Class<?> self = method2.getDeclaringClass();
        JvmMockKDispatcher dispatcher2 = JvmMockKDispatcher.get(id, self);
        if (dispatcher2 == null) {
            return null;
        }
        return dispatcher2.handler(self, method2, arguments2);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }
}

