/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;

public class ClassLoadingStrategyChooser {
    private static final Method PRIVATE_LOOKUP_IN;
    private static final Object LOOKUP;

    public static <T> ClassLoadingStrategy<ClassLoader> chooseClassLoadingStrategy(Class<T> type2) {
        try {
            ClassLoadingStrategy<ClassLoader> strategy;
            if (!type2.getName().startsWith("java.") && !type2.getName().startsWith("javax.") && ClassInjector.UsingLookup.isAvailable() && PRIVATE_LOOKUP_IN != null && LOOKUP != null) {
                Object privateLookup = PRIVATE_LOOKUP_IN.invoke(null, type2, LOOKUP);
                strategy = ClassLoadingStrategy.UsingLookup.of(privateLookup);
            } else {
                strategy = ClassInjector.UsingReflection.isAvailable() ? ClassLoadingStrategy.Default.INJECTION.with(type2.getProtectionDomain()) : ClassLoadingStrategy.Default.WRAPPER.with(type2.getProtectionDomain());
            }
            return strategy;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke 'privateLookupIn' method from java.lang.invoke.MethodHandles$Lookup.", e);
        }
    }

    static {
        Method privateLookupIn;
        Object lookup2;
        try {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            lookup2 = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
        }
        catch (Exception e) {
            privateLookupIn = null;
            lookup2 = null;
        }
        PRIVATE_LOOKUP_IN = privateLookupIn;
        LOOKUP = lookup2;
    }
}

