/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording.states;

import io.mockk.Invocation;
import io.mockk.InvocationMatcher;
import io.mockk.Matcher;
import io.mockk.MockKException;
import io.mockk.RecordedCall;
import io.mockk.impl.InternalPlatform;
import io.mockk.impl.log.Logger;
import io.mockk.impl.recording.CallRound;
import io.mockk.impl.recording.CallRoundBuilder;
import io.mockk.impl.recording.CommonCallRecorder;
import io.mockk.impl.recording.PermanentMocker;
import io.mockk.impl.recording.SignatureMatcherDetector;
import io.mockk.impl.recording.SignedCall;
import io.mockk.impl.recording.states.CallRecordingState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0004J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J1\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u00122\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"H\u0016\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u000fJ\b\u0010%\u001a\u00020\u001cH\u0016J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0012H\u0002J\u0014\u0010+\u001a\u00020\u001c2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\b\u0010,\u001a\u00020\u000fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lio/mockk/impl/recording/states/RecordingState;", "Lio/mockk/impl/recording/states/CallRecordingState;", "recorder", "Lio/mockk/impl/recording/CommonCallRecorder;", "(Lio/mockk/impl/recording/CommonCallRecorder;)V", "callRoundBuilder", "Lio/mockk/impl/recording/CallRoundBuilder;", "callRounds", "", "Lio/mockk/impl/recording/CallRound;", "log", "Lio/mockk/impl/log/Logger;", "getLog", "()Lio/mockk/impl/log/Logger;", "addWasNotCalled", "", "list", "", "", "builder", "call", "invocation", "Lio/mockk/Invocation;", "callIsNumberUnboxing", "", "Lio/mockk/RecordedCall;", "discardLastCallRound", "estimateCallRounds", "", "isLastCallReturnsNothing", "matcher", "T", "Lio/mockk/Matcher;", "cls", "Lkotlin/reflect/KClass;", "(Lio/mockk/Matcher;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "mockPermanently", "nCalls", "round", "total", "signMatchers", "typeEstimation", "it", "varArgTypeEstimation", "workaroundBoxedNumbers", "Companion", "mockk"})
@SourceDebugExtension(value={"SMAP\nRecordingState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordingState.kt\nio/mockk/impl/recording/states/RecordingState\n+ 2 Logger.kt\nio/mockk/impl/log/Logger$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n19#2:208\n819#3:209\n847#3,2:210\n766#3:212\n857#3,2:213\n1360#3:215\n1446#3,5:216\n1549#3:221\n1620#3,3:222\n1603#3,9:226\n1855#3:235\n1856#3:237\n1612#3:238\n1549#3:239\n1620#3,3:240\n1#4:225\n1#4:236\n*S KotlinDebug\n*F\n+ 1 RecordingState.kt\nio/mockk/impl/recording/states/RecordingState\n*L\n16#1:208\n105#1:209\n105#1:210,2\n110#1:212\n110#1:213,2\n147#1:215\n147#1:216,5\n149#1:221\n149#1:222,3\n153#1:226,9\n153#1:235\n153#1:237\n153#1:238\n159#1:239\n159#1:240,3\n153#1:236\n*E\n"})
public abstract class RecordingState
extends CallRecordingState {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @Nullable
    private CallRoundBuilder callRoundBuilder;
    @NotNull
    private final List<CallRound> callRounds;
    @Deprecated
    @NotNull
    private static final List<KClass<? extends Object>> CollectionTypes;

    public RecordingState(@NotNull CommonCallRecorder recorder) {
        Intrinsics.checkNotNullParameter(recorder, "recorder");
        super(recorder);
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$invoke = false;
        this.log = recorder.getSafeToString().invoke(this_$iv.getLoggerFactory().invoke(Reflection.getOrCreateKotlinClass(RecordingState.class)));
        this.callRounds = new ArrayList();
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void round(int round, int total) {
        CallRoundBuilder builder2 = this.callRoundBuilder;
        if (builder2 != null) {
            this.callRounds.add(builder2.build());
        }
        this.callRoundBuilder = this.getRecorder().getFactories().getCallRoundBuilder().invoke();
        this.getRecorder().setChildHinter(this.getRecorder().getFactories().getChildHinter().invoke());
        if (round == total) {
            this.signMatchers();
            this.workaroundBoxedNumbers();
            this.mockPermanently();
        }
    }

    private final void signMatchers() {
        SignatureMatcherDetector detector = this.getRecorder().getFactories().getSignatureMatcherDetector().invoke();
        detector.detect(this.callRounds);
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll((Collection<RecordedCall>)detector.getCalls());
    }

    @Override
    @NotNull
    public <T> T matcher(@NotNull Matcher<?> matcher, @NotNull KClass<T> cls) {
        Intrinsics.checkNotNullParameter(matcher, "matcher");
        Intrinsics.checkNotNullParameter(cls, "cls");
        T signatureValue = this.getRecorder().getSignatureValueGenerator().signatureValue(cls, this.getRecorder().getAnyValueGenerator(), this.getRecorder().getInstantiator());
        Object object = InternalPlatform.INSTANCE.packRef(signatureValue);
        if (object == null) {
            throw new IllegalStateException(("null packRef for " + cls + " signature " + signatureValue).toString());
        }
        Object packRef = object;
        this.builder().addMatcher(matcher, packRef);
        return signatureValue;
    }

    protected final void addWasNotCalled(@NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, "list");
        this.builder().addWasNotCalled(list);
    }

    @Override
    @Nullable
    public Object call(@NotNull Invocation invocation2) {
        Object retValue;
        Object object;
        Intrinsics.checkNotNullParameter(invocation2, "invocation");
        KClass<?> retType2 = this.getRecorder().getChildHinter().nextChildType(new Function0<KClass<?>>(invocation2){
            final /* synthetic */ Invocation $invocation;
            {
                this.$invocation = $invocation;
                super(0);
            }

            @NotNull
            public final KClass<?> invoke() {
                return this.$invocation.getMethod().getReturnType();
            }
        });
        Ref.BooleanRef isTemporaryMock = new Ref.BooleanRef();
        Function0 temporaryMock2 = new Function0<Object>(isTemporaryMock, this, retType2){
            final /* synthetic */ Ref.BooleanRef $isTemporaryMock;
            final /* synthetic */ RecordingState this$0;
            final /* synthetic */ KClass<?> $retType;
            {
                this.$isTemporaryMock = $isTemporaryMock;
                this.this$0 = $receiver;
                this.$retType = $retType;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                this.$isTemporaryMock.element = true;
                return this.this$0.getRecorder().getMockFactory().temporaryMock(this.$retType);
            }
        };
        if (invocation2.getMethod().isToString()) {
            object = this.getRecorder().getStubRepo().get(invocation2.getSelf());
            if (object == null || (object = object.toStr()) == null) {
                object = "";
            }
        } else {
            object = CollectionTypes.contains(retType2) ? temporaryMock2.invoke() : this.getRecorder().getAnyValueGenerator().invoke().anyValue(retType2, invocation2.getMethod().getReturnTypeNullable(), temporaryMock2);
        }
        if ((retValue = object) == null) {
            isTemporaryMock.element = false;
        }
        this.builder().addSignedCall(retValue, isTemporaryMock.element, retType2, invocation2);
        return retValue;
    }

    private final boolean callIsNumberUnboxing(RecordedCall call2) {
        InvocationMatcher matcher = call2.getMatcher();
        return matcher.getSelf() instanceof Number && StringsKt.endsWith$default(matcher.getMethod().getName(), "Value", false, 2, null) && matcher.getMethod().getParamTypes().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void workaroundBoxedNumbers() {
        void $this$filterNotTo$iv$iv;
        if (this.getRecorder().getCalls().size() == 1) {
            return;
        }
        Iterable $this$filterNot$iv = this.getRecorder().getCalls();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            RecordedCall it = (RecordedCall)element$iv$iv;
            boolean bl = false;
            if (this.callIsNumberUnboxing(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List callsWithoutCasts = (List)destination$iv$iv;
        if (callsWithoutCasts.size() != this.getRecorder().getCalls().size()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getRecorder().getCalls();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RecordedCall it = (RecordedCall)element$iv$iv;
                boolean bl = false;
                if (!this.callIsNumberUnboxing(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List callsWithCasts = (List)destination$iv$iv2;
            this.log.debug(new Function0<String>((List<RecordedCall>)callsWithCasts){
                final /* synthetic */ List<RecordedCall> $callsWithCasts;
                {
                    this.$callsWithCasts = $callsWithCasts;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Removed " + this.$callsWithCasts.size() + " unboxing calls:\n" + CollectionsKt.joinToString$default(this.$callsWithCasts, "\n", null, null, 0, null, null, 62, null);
                }
            });
        }
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll(callsWithoutCasts);
    }

    public final void mockPermanently() {
        PermanentMocker mocker = this.getRecorder().getFactories().getPermanentMocker().invoke();
        List<RecordedCall> resultCalls = mocker.mock(this.getRecorder().getCalls());
        this.getRecorder().getCalls().clear();
        this.getRecorder().getCalls().addAll((Collection<RecordedCall>)resultCalls);
    }

    @Override
    public int nCalls() {
        Object object = this.callRoundBuilder;
        return object != null && (object = ((CallRoundBuilder)object).getSignedCalls()) != null ? object.size() : 0;
    }

    @Override
    public boolean isLastCallReturnsNothing() {
        Object object = this.callRoundBuilder;
        if (object == null || (object = ((CallRoundBuilder)object).getSignedCalls()) == null || (object = (SignedCall)CollectionsKt.lastOrNull(object)) == null) {
            return false;
        }
        Object lastCall = object;
        return ((SignedCall)lastCall).getMethod().getReturnsNothing();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int estimateCallRounds() {
        Comparable comparable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Comparable comparable2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.builder().getSignedCalls();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SignedCall it = (SignedCall)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getArgs();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv2 = CollectionsKt.filterNotNull((List)destination$iv$iv);
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            list$iv$iv = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.typeEstimation(p0));
        }
        Iterator $i$f$map22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$map22.hasNext()) {
            comparable2 = null;
        } else {
            int it22 = ((Number)$i$f$map22.next()).intValue();
            boolean bl = false;
            Comparable it22 = Integer.valueOf(it22);
            while ($i$f$map22.hasNext()) {
                int it32 = ((Number)$i$f$map22.next()).intValue();
                $i$a$-maxOfOrNull-RecordingState$estimateCallRounds$regularArguments$3 = false;
                Comparable it32 = Integer.valueOf(it32);
                if (it22.compareTo(it32) >= 0) continue;
                it22 = it32;
            }
            comparable2 = it22;
        }
        Integer n = (Integer)comparable2;
        int regularArguments = n != null ? n : 1;
        $i$f$map22 = this.builder().getSignedCalls();
        boolean $i$f$mapNotNull = false;
        void it32 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            KClass<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            SignedCall it = (SignedCall)element$iv$iv;
            boolean bl3 = false;
            if ((it.getMethod().getVarArgsArg() != -1 ? it.getMethod().getParamTypes().get(it.getMethod().getVarArgsArg()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            bl = (KClass)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            collection.add(this.varArgTypeEstimation((KClass<?>)p0));
        }
        Iterator iterator2 = ((Iterable)((List)destination$iv$iv2)).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            int it = ((Number)iterator2.next()).intValue();
            boolean bl6 = false;
            Comparable comparable3 = Integer.valueOf(it);
            while (iterator2.hasNext()) {
                int it2 = ((Number)iterator2.next()).intValue();
                $i$a$-maxOfOrNull-RecordingState$estimateCallRounds$varargArguments$3 = false;
                Comparable comparable4 = Integer.valueOf(it2);
                if (comparable3.compareTo(comparable4) >= 0) continue;
                comparable3 = comparable4;
            }
            comparable = comparable3;
        }
        Integer n2 = (Integer)comparable;
        int varargArguments = n2 != null ? n2 : 1;
        return Math.max(regularArguments, varargArguments);
    }

    private final int typeEstimation(Object it) {
        KClass kClass = Reflection.getOrCreateKotlinClass(it.getClass());
        return Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? 40 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? 8 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Character.TYPE)) ? 4 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Short.TYPE)) ? 4 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? 2 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(Float.TYPE)) ? 2 : 1)))));
    }

    private final int varArgTypeEstimation(KClass<?> it) {
        KClass<?> kClass = it;
        return Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(boolean[].class)) ? 40 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(byte[].class)) ? 8 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(char[].class)) ? 4 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(short[].class)) ? 4 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(int[].class)) ? 2 : (Intrinsics.areEqual(kClass, Reflection.getOrCreateKotlinClass(float[].class)) ? 2 : 1)))));
    }

    @Override
    public void discardLastCallRound() {
        this.callRoundBuilder = null;
    }

    private final CallRoundBuilder builder() {
        CallRoundBuilder callRoundBuilder = this.callRoundBuilder;
        if (callRoundBuilder == null) {
            throw new MockKException("Call builder is not initialized. Bad state", null, 2, null);
        }
        return callRoundBuilder;
    }

    static {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(List.class), Reflection.getOrCreateKotlinClass(Map.class), Reflection.getOrCreateKotlinClass(Set.class), Reflection.getOrCreateKotlinClass(ArrayList.class), Reflection.getOrCreateKotlinClass(HashMap.class), Reflection.getOrCreateKotlinClass(HashSet.class)};
        CollectionTypes = CollectionsKt.listOf(kClassArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/mockk/impl/recording/states/RecordingState$Companion;", "", "()V", "CollectionTypes", "", "Lkotlin/reflect/KClass;", "mockk"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

