/*
 * Decompiled with CFR 0.152.
 */
package io.mockk;

import io.mockk.APIKt;
import io.mockk.CapturingMatcher;
import io.mockk.InternalPlatformDsl;
import io.mockk.Invocation;
import io.mockk.Matcher;
import io.mockk.MethodDescription;
import io.mockk.TypedMatcher;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010!\u001a\u00020\u00002\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010#J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/mockk/InvocationMatcher;", "", "self", "method", "Lio/mockk/MethodDescription;", "args", "", "Lio/mockk/Matcher;", "allAny", "", "(Ljava/lang/Object;Lio/mockk/MethodDescription;Ljava/util/List;Z)V", "getAllAny", "()Z", "getArgs", "()Ljava/util/List;", "getMethod", "()Lio/mockk/MethodDescription;", "getSelf", "()Ljava/lang/Object;", "captureAnswer", "", "invocation", "Lio/mockk/Invocation;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "match", "substitute", "map", "", "toString", "", "mockk-dsl"})
public final class InvocationMatcher {
    @NotNull
    private final Object self;
    @NotNull
    private final MethodDescription method;
    @NotNull
    private final List<Matcher<Object>> args;
    private final boolean allAny;

    public InvocationMatcher(@NotNull Object self, @NotNull MethodDescription method2, @NotNull List<? extends Matcher<Object>> args2, boolean allAny) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(args2, "args");
        this.self = self;
        this.method = method2;
        this.args = args2;
        this.allAny = allAny;
    }

    @NotNull
    public final Object getSelf() {
        return this.self;
    }

    @NotNull
    public final MethodDescription getMethod() {
        return this.method;
    }

    @NotNull
    public final List<Matcher<Object>> getArgs() {
        return this.args;
    }

    public final boolean getAllAny() {
        return this.allAny;
    }

    @NotNull
    public final InvocationMatcher substitute(@NotNull Map<Object, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        return new InvocationMatcher(APIKt.internalSubstitute(this.self, map2), APIKt.internalSubstitute(this.method, map2), APIKt.internalSubstitute(this.args, map2), this.allAny);
    }

    public final boolean match(@NotNull Invocation invocation2) {
        Intrinsics.checkNotNullParameter(invocation2, "invocation");
        if (this.self != invocation2.getSelf()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.method, invocation2.getMethod())) {
            return false;
        }
        if (this.allAny ? this.args.size() < invocation2.getArgs().size() : this.args.size() != invocation2.getArgs().size()) {
            return false;
        }
        int n = invocation2.getArgs().size();
        for (int i2 = 0; i2 < n; ++i2) {
            Matcher<Object> matcher = this.args.get(i2);
            Object arg = invocation2.getArgs().get(i2);
            if (matcher instanceof TypedMatcher && !((TypedMatcher)((Object)matcher)).checkType(arg)) {
                return false;
            }
            if (matcher.match(arg)) continue;
            return false;
        }
        return true;
    }

    public final void captureAnswer(@NotNull Invocation invocation2) {
        Intrinsics.checkNotNullParameter(invocation2, "invocation");
        Iterator<Matcher<Object>> iterator2 = this.args.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int idx = n++;
            Matcher<Object> argMatcher = iterator2.next();
            if (!(argMatcher instanceof CapturingMatcher)) continue;
            ((CapturingMatcher)((Object)argMatcher)).capture(invocation2.getArgs().get(idx));
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InvocationMatcher)) {
            return false;
        }
        return this.self != ((InvocationMatcher)other).self ? false : (!Intrinsics.areEqual(this.method, ((InvocationMatcher)other).method) ? false : Intrinsics.areEqual(this.args, ((InvocationMatcher)other).args));
    }

    public int hashCode() {
        int result2 = InternalPlatformDsl.INSTANCE.identityHashCode(this.self);
        result2 = 31 * result2 + this.method.hashCode();
        result2 = 31 * result2 + ((Object)this.args).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.self + '.' + this.method.getName() + '(' + CollectionsKt.joinToString$default(this.args, ", ", null, null, 0, null, null, 62, null) + "))";
    }

    @NotNull
    public final Object component1() {
        return this.self;
    }

    @NotNull
    public final MethodDescription component2() {
        return this.method;
    }

    @NotNull
    public final List<Matcher<Object>> component3() {
        return this.args;
    }

    public final boolean component4() {
        return this.allAny;
    }

    @NotNull
    public final InvocationMatcher copy(@NotNull Object self, @NotNull MethodDescription method2, @NotNull List<? extends Matcher<Object>> args2, boolean allAny) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(method2, "method");
        Intrinsics.checkNotNullParameter(args2, "args");
        return new InvocationMatcher(self, method2, args2, allAny);
    }

    public static /* synthetic */ InvocationMatcher copy$default(InvocationMatcher invocationMatcher, Object object, MethodDescription methodDescription, List list, boolean bl, int n, Object object2) {
        if ((n & 1) != 0) {
            object = invocationMatcher.self;
        }
        if ((n & 2) != 0) {
            methodDescription = invocationMatcher.method;
        }
        if ((n & 4) != 0) {
            list = invocationMatcher.args;
        }
        if ((n & 8) != 0) {
            bl = invocationMatcher.allAny;
        }
        return invocationMatcher.copy(object, methodDescription, list, bl);
    }
}

