/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.util;

import io.ktor.util.InternalAPI;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\t\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0007\u001a\f\u0010\r\u001a\u00020\t*\u00020\fH\u0007\"\u001c\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"GreenwichMeanTime", "Ljava/time/ZoneId;", "getGreenwichMeanTime$annotations", "()V", "getGreenwichMeanTime", "()Ljava/time/ZoneId;", "toGMTDate", "Lio/ktor/util/date/GMTDate;", "Ljava/time/Instant;", "Ljava/time/ZonedDateTime;", "toLocalDateTime", "Ljava/time/LocalDateTime;", "Ljava/util/Date;", "toZonedDateTime", "ktor-server-core"})
public final class DateUtilsJvmKt {
    @NotNull
    private static final ZoneId GreenwichMeanTime;

    @NotNull
    public static final GMTDate toGMTDate(@NotNull Instant $this$toGMTDate) {
        Intrinsics.checkNotNullParameter($this$toGMTDate, "<this>");
        return DateJvmKt.GMTDate(TimeUnit.SECONDS.toMillis($this$toGMTDate.atZone(ZoneOffset.UTC).toEpochSecond()));
    }

    @NotNull
    public static final GMTDate toGMTDate(@NotNull ZonedDateTime $this$toGMTDate) {
        Intrinsics.checkNotNullParameter($this$toGMTDate, "<this>");
        Instant instant = $this$toGMTDate.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "toInstant()");
        return DateUtilsJvmKt.toGMTDate(instant);
    }

    @InternalAPI
    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull Date $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toLocalDateTime, "<this>");
        LocalDateTime localDateTime = LocalDateTime.ofInstant($this$toLocalDateTime.toInstant(), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue(localDateTime, "ofInstant(toInstant(), ZoneId.systemDefault())");
        return localDateTime;
    }

    @InternalAPI
    @NotNull
    public static final ZonedDateTime toZonedDateTime(@NotNull Date $this$toZonedDateTime) {
        Intrinsics.checkNotNullParameter($this$toZonedDateTime, "<this>");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant($this$toZonedDateTime.toInstant(), GreenwichMeanTime);
        Intrinsics.checkNotNullExpressionValue(zonedDateTime, "ofInstant(toInstant(), GreenwichMeanTime)");
        return zonedDateTime;
    }

    @NotNull
    public static final ZoneId getGreenwichMeanTime() {
        return GreenwichMeanTime;
    }

    @InternalAPI
    public static /* synthetic */ void getGreenwichMeanTime$annotations() {
    }

    static {
        ZoneId zoneId = ZoneId.of("GMT");
        Intrinsics.checkNotNullExpressionValue(zoneId, "of(\"GMT\")");
        GreenwichMeanTime = zoneId;
    }
}

