/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.ParametersKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/routing/ParameterRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "evaluate", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "context", "Lio/ktor/server/routing/RoutingResolveContext;", "segmentIndex", "", "hashCode", "toString", "ktor-server-core"})
public final class ParameterRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;

    public ParameterRouteSelector(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Intrinsics.checkNotNullParameter(context, "context");
        List<String> param = context.getCall().getParameters().getAll(this.name);
        if (param != null) {
            return new RouteSelectorEvaluation.Success(1.0, ParametersKt.parametersOf(this.name, param), 0, 4, null);
        }
        return RouteSelectorEvaluation.Companion.getFailedParameter();
    }

    @NotNull
    public String toString() {
        return '[' + this.name + ']';
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final ParameterRouteSelector copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new ParameterRouteSelector(name);
    }

    public static /* synthetic */ ParameterRouteSelector copy$default(ParameterRouteSelector parameterRouteSelector, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = parameterRouteSelector.name;
        }
        return parameterRouteSelector.copy(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParameterRouteSelector)) {
            return false;
        }
        ParameterRouteSelector parameterRouteSelector = (ParameterRouteSelector)other;
        return Intrinsics.areEqual(this.name, parameterRouteSelector.name);
    }
}

