/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http1;

import io.ktor.http.Headers;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.netty.NettyApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestHeaders;
import io.ktor.server.netty.http1.NettyConnectionPoint;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/netty/http1/NettyHttp1ApplicationRequest;", "Lio/ktor/server/netty/NettyApplicationRequest;", "call", "Lio/ktor/server/application/ApplicationCall;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "context", "Lio/netty/channel/ChannelHandlerContext;", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "requestBodyChannel", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http/HttpRequest;Lio/ktor/utils/io/ByteReadChannel;)V", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getHttpRequest", "()Lio/netty/handler/codec/http/HttpRequest;", "local", "Lio/ktor/server/netty/http1/NettyConnectionPoint;", "getLocal", "()Lio/ktor/server/netty/http1/NettyConnectionPoint;", "newDecoder", "Lio/netty/handler/codec/http/multipart/HttpPostMultipartRequestDecoder;", "ktor-server-netty"})
public final class NettyHttp1ApplicationRequest
extends NettyApplicationRequest {
    @NotNull
    private final HttpRequest httpRequest;
    @NotNull
    private final NettyConnectionPoint local;
    @NotNull
    private final Headers headers;

    public NettyHttp1ApplicationRequest(@NotNull ApplicationCall call2, @NotNull CoroutineContext coroutineContext2, @NotNull ChannelHandlerContext context, @NotNull HttpRequest httpRequest, @NotNull ByteReadChannel requestBodyChannel) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(coroutineContext2, "coroutineContext");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(httpRequest, "httpRequest");
        Intrinsics.checkNotNullParameter(requestBodyChannel, "requestBodyChannel");
        String string = httpRequest.uri();
        Intrinsics.checkNotNullExpressionValue(string, "httpRequest.uri()");
        super(call2, coroutineContext2, context, requestBodyChannel, string, HttpUtil.isKeepAlive(httpRequest));
        this.httpRequest = httpRequest;
        this.local = new NettyConnectionPoint(this.httpRequest, context);
        this.headers = new NettyApplicationRequestHeaders(this.httpRequest);
    }

    @NotNull
    public final HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    @NotNull
    public NettyConnectionPoint getLocal() {
        return this.local;
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    @NotNull
    protected HttpPostMultipartRequestDecoder newDecoder() {
        return new HttpPostMultipartRequestDecoder(this.httpRequest);
    }
}

