/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.events.EventsKt;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.DefaultUncaughtExceptionHandler;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineConnectorConfigJvmKt;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.netty.NettyApplicationEngineKt;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.util.network.NetworkAddressJvmKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001>B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u00020\u0007H\u0002J\b\u0010<\u001a\u00020=H\u0016R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001c\u0010\u0014R\u001b\u0010\u001e\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0010\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0010\u001a\u0004\b$\u0010%R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0010\u001a\u0004\b+\u0010,R\u001b\u0010.\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0010\u001a\u0004\b/\u0010\u0014\u00a8\u0006?"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "bootstraps", "", "Lio/netty/bootstrap/ServerBootstrap;", "getBootstraps$ktor_server_netty", "()Ljava/util/List;", "bootstraps$delegate", "Lkotlin/Lazy;", "callEventGroup", "Lio/netty/channel/EventLoopGroup;", "getCallEventGroup", "()Lio/netty/channel/EventLoopGroup;", "callEventGroup$delegate", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "channels", "Lio/netty/channel/Channel;", "configuration", "connectionEventGroup", "getConnectionEventGroup", "connectionEventGroup$delegate", "customBootstrap", "getCustomBootstrap", "()Lio/netty/bootstrap/ServerBootstrap;", "customBootstrap$delegate", "nettyDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getNettyDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "nettyDispatcher$delegate", "userContext", "Lkotlin/coroutines/CoroutineContext;", "workerDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "getWorkerDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "workerDispatcher$delegate", "workerEventGroup", "getWorkerEventGroup", "workerEventGroup$delegate", "createBootstrap", "connector", "Lio/ktor/server/engine/EngineConnectorConfig;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "terminate", "toString", "", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Lazy connectionEventGroup$delegate;
    @NotNull
    private final Lazy workerEventGroup$delegate;
    @NotNull
    private final Lazy customBootstrap$delegate;
    @NotNull
    private final Lazy callEventGroup$delegate;
    @NotNull
    private final Lazy nettyDispatcher$delegate;
    @NotNull
    private final Lazy workerDispatcher$delegate;
    @Nullable
    private CompletableJob cancellationDeferred;
    @Nullable
    private List<? extends Channel> channels;
    @NotNull
    private final Lazy bootstraps$delegate;
    @NotNull
    private final CoroutineContext userContext;

    public NettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull Function1<? super Configuration, Unit> configure) {
        Intrinsics.checkNotNullParameter(environment2, "environment");
        Intrinsics.checkNotNullParameter(configure, "configure");
        super(environment2, null, 2, null);
        Configuration configuration = new Configuration();
        configure.invoke(configuration);
        this.configuration = configuration;
        this.connectionEventGroup$delegate = LazyKt.lazy((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap(this.this$0).config().group();
                if (eventLoopGroup == null) {
                    eventLoopGroup = EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConnectionGroupSize());
                }
                return eventLoopGroup;
            }
        });
        this.workerEventGroup$delegate = LazyKt.lazy((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                EventLoopGroup eventLoopGroup = NettyApplicationEngine.access$getCustomBootstrap(this.this$0).config().childGroup();
                if (eventLoopGroup != null) {
                    EventLoopGroup it = eventLoopGroup;
                    boolean bl = false;
                    return it;
                }
                return NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize() + NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize()) : EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getWorkerGroupSize());
            }
        });
        this.customBootstrap$delegate = LazyKt.lazy((Function0)new Function0<ServerBootstrap>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ServerBootstrap invoke() {
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                NettyApplicationEngine.access$getConfiguration$p(this.this$0).getConfigureBootstrap().invoke(serverBootstrap);
                return serverBootstrap;
            }
        });
        this.callEventGroup$delegate = LazyKt.lazy((Function0)new Function0<EventLoopGroup>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventLoopGroup invoke() {
                return NettyApplicationEngine.access$getConfiguration$p(this.this$0).getShareWorkGroup() ? NettyApplicationEngine.access$getWorkerEventGroup(this.this$0) : (EventLoopGroup)EventLoopGroupProxy.Companion.create(NettyApplicationEngine.access$getConfiguration$p(this.this$0).getCallGroupSize());
            }
        });
        this.nettyDispatcher$delegate = LazyKt.lazy(nettyDispatcher.2.INSTANCE);
        this.workerDispatcher$delegate = LazyKt.lazy((Function0)new Function0<ExecutorCoroutineDispatcher>(this){
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ExecutorCoroutineDispatcher invoke() {
                return ExecutorsKt.from(NettyApplicationEngine.access$getWorkerEventGroup(this.this$0));
            }
        });
        this.bootstraps$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ServerBootstrap>>(environment2, this){
            final /* synthetic */ ApplicationEngineEnvironment $environment;
            final /* synthetic */ NettyApplicationEngine this$0;
            {
                this.$environment = $environment;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ServerBootstrap> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$environment.getConnectors();
                NettyApplicationEngine nettyApplicationEngine = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(NettyApplicationEngine.access$createBootstrap(nettyApplicationEngine, (EngineConnectorConfig)p0));
                }
                return (List)destination$iv$iv;
            }
        });
        this.userContext = environment2.getParentCoroutineContext().plus(this.getNettyDispatcher()).plus(NettyApplicationCallHandler.Companion.getCallHandlerCoroutineName$ktor_server_netty()).plus(new DefaultUncaughtExceptionHandler(environment2.getLog()));
        PipelinePhase afterCall = new PipelinePhase("After");
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), afterCall);
        this.getPipeline().intercept(afterCall, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PipelineContext $this$intercept;
                        ResultKt.throwOnFailure(object);
                        PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                        boolean $i$f$getCall = false;
                        ApplicationCall applicationCall = (ApplicationCall)$this$call$iv.getContext();
                        NettyApplicationCall nettyApplicationCall = applicationCall instanceof NettyApplicationCall ? (NettyApplicationCall)applicationCall : null;
                        if (nettyApplicationCall == null) break;
                        this.label = 1;
                        Object object3 = nettyApplicationCall.finish$ktor_server_netty(this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            @Nullable
            public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ NettyApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(applicationEngineEnvironment, function1);
    }

    private final EventLoopGroup getConnectionEventGroup() {
        Lazy lazy = this.connectionEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final EventLoopGroup getWorkerEventGroup() {
        Lazy lazy = this.workerEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final ServerBootstrap getCustomBootstrap() {
        Lazy lazy = this.customBootstrap$delegate;
        return (ServerBootstrap)lazy.getValue();
    }

    private final EventLoopGroup getCallEventGroup() {
        Lazy lazy = this.callEventGroup$delegate;
        return (EventLoopGroup)lazy.getValue();
    }

    private final CoroutineDispatcher getNettyDispatcher() {
        Lazy lazy = this.nettyDispatcher$delegate;
        return (CoroutineDispatcher)lazy.getValue();
    }

    private final ExecutorCoroutineDispatcher getWorkerDispatcher() {
        Lazy lazy = this.workerDispatcher$delegate;
        return (ExecutorCoroutineDispatcher)lazy.getValue();
    }

    @NotNull
    public final List<ServerBootstrap> getBootstraps$ktor_server_netty() {
        Lazy lazy = this.bootstraps$delegate;
        return (List)lazy.getValue();
    }

    private final ServerBootstrap createBootstrap(EngineConnectorConfig connector) {
        ServerBootstrap serverBootstrap;
        ServerBootstrap $this$createBootstrap_u24lambda_u240 = serverBootstrap = this.getCustomBootstrap().clone();
        boolean bl = false;
        if ($this$createBootstrap_u24lambda_u240.config().group() == null && $this$createBootstrap_u24lambda_u240.config().childGroup() == null) {
            $this$createBootstrap_u24lambda_u240.group(this.getConnectionEventGroup(), this.getWorkerEventGroup());
        }
        if ($this$createBootstrap_u24lambda_u240.config().channelFactory() == null) {
            $this$createBootstrap_u24lambda_u240.channel(JvmClassMappingKt.getJavaClass(NettyApplicationEngineKt.access$getChannelClass()));
        }
        $this$createBootstrap_u24lambda_u240.childHandler(new NettyChannelInitializer(this.getPipeline(), this.getEnvironment(), this.getCallEventGroup(), this.getWorkerDispatcher(), this.userContext, connector, this.configuration.getRequestQueueLimit(), this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec(), this.configuration.getChannelPipelineConfig()));
        if (this.configuration.getTcpKeepAlive()) {
            $this$createBootstrap_u24lambda_u240.childOption(ChannelOption.SO_KEEPALIVE, true);
        }
        ServerBootstrap serverBootstrap2 = serverBootstrap;
        Intrinsics.checkNotNullExpressionValue(serverBootstrap2, "customBootstrap.clone().\u2026)\n            }\n        }");
        return serverBootstrap2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        Iterable destination$iv$iv;
        Object object;
        this.getEnvironment().start();
        try {
            void $this$mapTo$iv$iv;
            ChannelFuture it;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)this.getBootstraps$ktor_server_netty(), (Iterable)this.getEnvironment().getConnectors());
            object = this;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((ServerBootstrap)((Pair)((Object)it)).getFirst()).bind(((EngineConnectorConfig)((Pair)((Object)it)).getSecond()).getHost(), ((EngineConnectorConfig)((Pair)((Object)it)).getSecond()).getPort()));
            }
            $this$map$iv = (List)destination$iv$iv2;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (ChannelFuture)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.sync().channel());
            }
            ((NettyApplicationEngine)object).channels = (List)destination$iv$iv2;
            List<? extends Channel> list = this.channels;
            Intrinsics.checkNotNull(list);
            Iterable $this$map$iv2 = CollectionsKt.zip((Iterable)list, (Iterable)this.getEnvironment().getConnectors());
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Pair bl = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)it2.getSecond();
                SocketAddress socketAddress = ((Channel)it2.getFirst()).localAddress();
                Intrinsics.checkNotNullExpressionValue(socketAddress, "it.first.localAddress()");
                object.add(EngineConnectorConfigJvmKt.withPort(engineConnectorConfig, NetworkAddressJvmKt.getPort(socketAddress)));
            }
            List connectors = (List)destination$iv$iv;
            this.getResolvedConnectors().complete(connectors);
        }
        catch (BindException cause) {
            this.terminate();
            throw cause;
        }
        EventsKt.raiseCatching(this.getEnvironment().getMonitor(), DefaultApplicationEventsKt.getServerReady(), this.getEnvironment(), this.getEnvironment().getLog());
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation(this);
        if (wait) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Channel bl2 = (Channel)item$iv$iv;
                    object = destination$iv$iv3;
                    boolean bl = false;
                    object.add(it.closeFuture());
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ChannelFuture it = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it.sync();
                }
            }
            ApplicationEngineJvmKt.stop(this, 1L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    private final void terminate() {
        this.getConnectionEventGroup().shutdownGracefully().sync();
        this.getWorkerEventGroup().shutdownGracefully().sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        List list;
        List list2;
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), this.getEnvironment());
        List<? extends Channel> list3 = this.channels;
        if (list3 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list3;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ChannelFuture it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if ((it.isOpen() ? it.close() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List channelFutures = list;
        try {
            Future<?> shutdownConnections = this.getConnectionEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            shutdownConnections.await();
            Future<?> shutdownWorkers = this.getWorkerEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                shutdownWorkers.await();
            } else {
                Future<?> shutdownCall = this.getCallEventGroup().shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
                shutdownWorkers.await();
                shutdownCall.await();
            }
            this.getEnvironment().stop();
        }
        finally {
            Iterable $this$forEach$iv = channelFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    public static final /* synthetic */ ServerBootstrap access$getCustomBootstrap(NettyApplicationEngine $this) {
        return $this.getCustomBootstrap();
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(NettyApplicationEngine $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ EventLoopGroup access$getWorkerEventGroup(NettyApplicationEngine $this) {
        return $this.getWorkerEventGroup();
    }

    public static final /* synthetic */ ServerBootstrap access$createBootstrap(NettyApplicationEngine $this, EngineConnectorConfig connector) {
        return $this.createBootstrap(connector);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00108\u001a\u00020\u0012H\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001a\u0010)\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001a\u0010,\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104\u00a8\u00069"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "channelPipelineConfig", "Lkotlin/Function1;", "Lio/netty/channel/ChannelPipeline;", "", "Lkotlin/ExtensionFunctionType;", "getChannelPipelineConfig", "()Lkotlin/jvm/functions/Function1;", "setChannelPipelineConfig", "(Lkotlin/jvm/functions/Function1;)V", "configureBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "getConfigureBootstrap", "setConfigureBootstrap", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "maxChunkSize", "", "getMaxChunkSize", "()I", "setMaxChunkSize", "(I)V", "maxHeaderSize", "getMaxHeaderSize", "setMaxHeaderSize", "maxInitialLineLength", "getMaxInitialLineLength", "setMaxInitialLineLength", "requestQueueLimit", "getRequestQueueLimit", "setRequestQueueLimit", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "runningLimit", "getRunningLimit", "setRunningLimit", "shareWorkGroup", "", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "tcpKeepAlive", "getTcpKeepAlive", "setTcpKeepAlive", "defaultHttpServerCodec", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int requestQueueLimit = 16;
        private int runningLimit = 32;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = configureBootstrap.1.INSTANCE;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        private boolean tcpKeepAlive;
        private int maxInitialLineLength = 4096;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = new Function0<HttpServerCodec>((Object)this){

            @NotNull
            public final HttpServerCodec invoke() {
                return Configuration.access$defaultHttpServerCodec((Configuration)this.receiver);
            }
        };
        @NotNull
        private Function1<? super ChannelPipeline, Unit> channelPipelineConfig = channelPipelineConfig.1.INSTANCE;

        public final int getRequestQueueLimit() {
            return this.requestQueueLimit;
        }

        public final void setRequestQueueLimit(int n) {
            this.requestQueueLimit = n;
        }

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n) {
            this.requestReadTimeoutSeconds = n;
        }

        public final boolean getTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public final void setTcpKeepAlive(boolean bl) {
            this.tcpKeepAlive = bl;
        }

        public final int getMaxInitialLineLength() {
            return this.maxInitialLineLength;
        }

        public final void setMaxInitialLineLength(int n) {
            this.maxInitialLineLength = n;
        }

        public final int getMaxHeaderSize() {
            return this.maxHeaderSize;
        }

        public final void setMaxHeaderSize(int n) {
            this.maxHeaderSize = n;
        }

        public final int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        public final void setMaxChunkSize(int n) {
            this.maxChunkSize = n;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkNotNullParameter(function0, "<set-?>");
            this.httpServerCodec = function0;
        }

        @NotNull
        public final Function1<ChannelPipeline, Unit> getChannelPipelineConfig() {
            return this.channelPipelineConfig;
        }

        public final void setChannelPipelineConfig(@NotNull Function1<? super ChannelPipeline, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.channelPipelineConfig = function1;
        }

        private final HttpServerCodec defaultHttpServerCodec() {
            return new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize);
        }

        public static final /* synthetic */ HttpServerCodec access$defaultHttpServerCodec(Configuration $this) {
            return $this.defaultHttpServerCodec();
        }
    }
}

