/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.extensions;

import io.ktor.network.tls.TLSException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lio/ktor/network/tls/extensions/HashAlgorithm;", "", "code", "", "openSSLName", "", "macName", "(Ljava/lang/String;IBLjava/lang/String;Ljava/lang/String;)V", "getCode", "()B", "getMacName", "()Ljava/lang/String;", "getOpenSSLName", "NONE", "MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "INTRINSIC", "Companion", "ktor-network-tls"})
public final class HashAlgorithm
extends Enum<HashAlgorithm> {
    @NotNull
    public static final Companion Companion;
    private final byte code;
    @NotNull
    private final String openSSLName;
    @NotNull
    private final String macName;
    public static final /* enum */ HashAlgorithm NONE;
    public static final /* enum */ HashAlgorithm MD5;
    public static final /* enum */ HashAlgorithm SHA1;
    public static final /* enum */ HashAlgorithm SHA224;
    public static final /* enum */ HashAlgorithm SHA256;
    public static final /* enum */ HashAlgorithm SHA384;
    public static final /* enum */ HashAlgorithm SHA512;
    public static final /* enum */ HashAlgorithm INTRINSIC;
    private static final /* synthetic */ HashAlgorithm[] $VALUES;

    private HashAlgorithm(byte code, String openSSLName, String macName) {
        this.code = code;
        this.openSSLName = openSSLName;
        this.macName = macName;
    }

    public final byte getCode() {
        return this.code;
    }

    @NotNull
    public final String getOpenSSLName() {
        return this.openSSLName;
    }

    @NotNull
    public final String getMacName() {
        return this.macName;
    }

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String value) {
        return Enum.valueOf(HashAlgorithm.class, value);
    }

    static {
        NONE = new HashAlgorithm(0, "", "");
        MD5 = new HashAlgorithm(1, "MD5", "HmacMD5");
        SHA1 = new HashAlgorithm(2, "SHA-1", "HmacSHA1");
        SHA224 = new HashAlgorithm(3, "SHA-224", "HmacSHA224");
        SHA256 = new HashAlgorithm(4, "SHA-256", "HmacSHA256");
        SHA384 = new HashAlgorithm(5, "SHA-384", "HmacSHA384");
        SHA512 = new HashAlgorithm(6, "SHA-512", "HmacSHA512");
        INTRINSIC = new HashAlgorithm(8, "INTRINSIC", "Intrinsic");
        $VALUES = hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.NONE, HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA224, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512, HashAlgorithm.INTRINSIC};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/network/tls/extensions/HashAlgorithm$Companion;", "", "()V", "byCode", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "code", "", "ktor-network-tls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashAlgorithm byCode(byte code) {
            HashAlgorithm hashAlgorithm;
            block2: {
                HashAlgorithm[] hashAlgorithmArray = HashAlgorithm.values();
                int n = hashAlgorithmArray.length;
                for (int j = 0; j < n; ++j) {
                    HashAlgorithm hashAlgorithm2;
                    HashAlgorithm it = hashAlgorithm2 = hashAlgorithmArray[j];
                    boolean bl = false;
                    if (!(it.getCode() == code)) continue;
                    hashAlgorithm = hashAlgorithm2;
                    break block2;
                }
                hashAlgorithm = null;
            }
            if (hashAlgorithm == null) {
                throw new TLSException("Unknown hash algorithm: " + code, null, 2, null);
            }
            return hashAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

