/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.certificates.BuildersKt;
import io.ktor.network.tls.certificates.CertificateBuilder;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.KeyStoreBuilder;
import io.ktor.network.tls.certificates.KeyType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.CloseableJVMKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0014\u001aN\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001aq\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0006H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b$\u0010%\u001a\f\u0010&\u001a\u00020'*\u00020(H\u0002\u001a\f\u0010)\u001a\u00020'*\u00020(H\u0002\u001a\f\u0010*\u001a\u00020\u0014*\u00020\u0014H\u0002\u001a%\u0010+\u001a\u00020'*\u00020(2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0002\u001af\u0010\u000b\u001a\u00020\b*\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010/\u001a\u00020\u000f2\b\b\u0002\u00100\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\f\u00101\u001a\u00020'*\u00020(H\u0002\u001a(\u00102\u001a\u00020'*\u00020(2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0006H\u0002\u001a\u0014\u00103\u001a\u000204*\u000205H\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\u00106\u001a \u00107\u001a\u00020\b*\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u00108\u001a\u000209\u001a\u0014\u0010:\u001a\u00020'*\u00020(2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u0010;\u001a\u00020'*\u00020(2\u0006\u0010<\u001a\u00020=H\u0002\u001a\u0014\u0010;\u001a\u00020'*\u00020(2\u0006\u0010<\u001a\u00020\u0014H\u0002\u001aj\u0010>\u001a\u00020'*\u00020(2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010B\u001a\u00020'*\u00020(2\u0006\u0010C\u001a\u00020D2\b\b\u0002\u0010E\u001a\u00020\u0014H\u0002\u001a\u0014\u0010F\u001a\u00020'*\u00020(2\u0006\u0010<\u001a\u000205H\u0002\u001a\u0014\u0010G\u001a\u00020'*\u00020(2\u0006\u0010H\u001a\u00020@H\u0002\u001a\u0014\u0010I\u001a\u00020'*\u00020(2\u0006\u0010<\u001a\u00020\u0014H\u0002\u001a\u0014\u0010J\u001a\u00020'*\u00020(2\u0006\u0010K\u001a\u00020\u0014H\u0002\u001a\f\u0010L\u001a\u00020'*\u00020(H\u0002\u001a\u0014\u0010M\u001a\u00020'*\u00020(2\u0006\u0010N\u001a\u00020OH\u0002\u001a\u0014\u0010M\u001a\u00020'*\u00020(2\u0006\u0010N\u001a\u00020PH\u0002\u001a%\u0010Q\u001a\u00020'*\u00020(2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0002\u001a%\u0010S\u001a\u00020'*\u00020(2\u0017\u0010R\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0002\u001a$\u0010T\u001a\u00020'*\u00020(2\u0006\u0010U\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u00142\u0006\u0010W\u001a\u000205H\u0002\u001a\u0014\u0010X\u001a\u00020'*\u00020(2\u0006\u0010H\u001a\u00020@H\u0002\u001a\u001e\u0010Y\u001a\u00020'*\u00020(2\u0006\u0010Z\u001a\u00020\u000f2\b\b\u0002\u0010[\u001a\u00020\u0014H\u0002\u001a\u0016\u0010\\\u001a\u00020'*\u00020(2\b\b\u0002\u0010]\u001a\u00020\u0014H\u0002\u001a\u0014\u0010^\u001a\u00020'*\u00020(2\u0006\u0010_\u001a\u00020\u0001H\u0002\u001a-\u0010`\u001a\u00020'*\u00020(2\u0006\u0010a\u001a\u00020\u00142\u0017\u0010b\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020'0-\u00a2\u0006\u0002\b.H\u0002\u001ab\u0010c\u001a\u00020'*\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006d"}, d2={"DEFAULT_CA_PRINCIPAL", "Ljavax/security/auth/x500/X500Principal;", "DEFAULT_PRINCIPAL", "getDEFAULT_PRINCIPAL", "()Ljavax/security/auth/x500/X500Principal;", "trustManagers", "", "Ljavax/net/ssl/TrustManager;", "Ljava/security/KeyStore;", "getTrustManagers", "(Ljava/security/KeyStore;)Ljava/util/List;", "generateCertificate", "file", "Ljava/io/File;", "algorithm", "", "keyAlias", "keyPassword", "jksPassword", "keySizeInBits", "", "keyType", "Lio/ktor/network/tls/certificates/KeyType;", "generateX509Certificate", "Ljava/security/cert/X509Certificate;", "subject", "issuer", "publicKey", "Ljava/security/PublicKey;", "signerKeyPair", "Ljava/security/KeyPair;", "validityDuration", "Lkotlin/time/Duration;", "domains", "ipAddresses", "Ljava/net/InetAddress;", "generateX509Certificate-Tu6dINM", "(Ljavax/security/auth/x500/X500Principal;Ljavax/security/auth/x500/X500Principal;Ljava/security/PublicKey;Ljava/security/KeyPair;Ljava/lang/String;JLio/ktor/network/tls/certificates/KeyType;Ljava/util/List;Ljava/util/List;)Ljava/security/cert/X509Certificate;", "caExtension", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "clientAuth", "derLength", "extKeyUsage", "content", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "caKeyAlias", "caPassword", "serverAuth", "subjectAlternativeNames", "toUByte", "Lkotlin/UByte;", "", "(Z)B", "trustStore", "password", "", "writeAlgorithmIdentifier", "writeAsnInt", "value", "Ljava/math/BigInteger;", "writeCertificate", "validFrom", "Ljava/time/Instant;", "validUntil", "writeDerBitString", "array", "", "unused", "writeDerBoolean", "writeDerGeneralizedTime", "date", "writeDerInt", "writeDerLength", "length", "writeDerNull", "writeDerObjectIdentifier", "identifier", "Lio/ktor/network/tls/OID;", "", "writeDerOctetString", "block", "writeDerSequence", "writeDerType", "kind", "typeIdentifier", "simpleType", "writeDerUTCTime", "writeDerUTF8String", "s", "type", "writeVersion", "v", "writeX500Principal", "dName", "writeX509Extension", "id", "builder", "writeX509Info", "ktor-network-tls-certificates"})
public final class CertificatesKt {
    @NotNull
    private static final X500Principal DEFAULT_PRINCIPAL = new X500Principal("CN=localhost, OU=Kotlin, O=JetBrains, C=RU");
    @NotNull
    private static final X500Principal DEFAULT_CA_PRINCIPAL = new X500Principal("CN=localhostCA, OU=Kotlin, O=JetBrains, C=RU");

    @NotNull
    public static final X500Principal getDEFAULT_PRINCIPAL() {
        return DEFAULT_PRINCIPAL;
    }

    @NotNull
    public static final KeyStore generateCertificate(@Nullable File file2, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull KeyType keyType) {
        KeyStore keyStore2;
        block0: {
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            Intrinsics.checkNotNullParameter(keyAlias, "keyAlias");
            Intrinsics.checkNotNullParameter(keyPassword, "keyPassword");
            Intrinsics.checkNotNullParameter(jksPassword, "jksPassword");
            Intrinsics.checkNotNullParameter((Object)keyType, "keyType");
            keyStore2 = BuildersKt.buildKeyStore((Function1<? super KeyStoreBuilder, Unit>)new Function1<KeyStoreBuilder, Unit>(keyAlias, algorithm, keyPassword, keySizeInBits, keyType){
                final /* synthetic */ String $keyAlias;
                final /* synthetic */ String $algorithm;
                final /* synthetic */ String $keyPassword;
                final /* synthetic */ int $keySizeInBits;
                final /* synthetic */ KeyType $keyType;
                {
                    this.$keyAlias = $keyAlias;
                    this.$algorithm = $algorithm;
                    this.$keyPassword = $keyPassword;
                    this.$keySizeInBits = $keySizeInBits;
                    this.$keyType = $keyType;
                    super(1);
                }

                public final void invoke(@NotNull KeyStoreBuilder $this$buildKeyStore) {
                    Intrinsics.checkNotNullParameter($this$buildKeyStore, "$this$buildKeyStore");
                    $this$buildKeyStore.certificate(this.$keyAlias, (Function1<? super CertificateBuilder, Unit>)new Function1<CertificateBuilder, Unit>(this.$algorithm, this.$keyPassword, this.$keySizeInBits, this.$keyType){
                        final /* synthetic */ String $algorithm;
                        final /* synthetic */ String $keyPassword;
                        final /* synthetic */ int $keySizeInBits;
                        final /* synthetic */ KeyType $keyType;
                        {
                            this.$algorithm = $algorithm;
                            this.$keyPassword = $keyPassword;
                            this.$keySizeInBits = $keySizeInBits;
                            this.$keyType = $keyType;
                            super(1);
                        }

                        public final void invoke(@NotNull CertificateBuilder $this$certificate) {
                            Intrinsics.checkNotNullParameter($this$certificate, "$this$certificate");
                            String[] stringArray = new String[]{"with"};
                            List list = StringsKt.split$default((CharSequence)this.$algorithm, stringArray, false, 0, 6, null);
                            String hashName = (String)list.get(0);
                            String signName = (String)list.get(1);
                            $this$certificate.setHash(HashAlgorithm.valueOf(hashName));
                            $this$certificate.setSign(SignatureAlgorithm.valueOf(signName));
                            $this$certificate.setPassword(this.$keyPassword);
                            $this$certificate.setKeySizeInBits(this.$keySizeInBits);
                            $this$certificate.setKeyType(this.$keyType);
                            $this$certificate.setSubject(this.$keyType == KeyType.CA ? CertificatesKt.access$getDEFAULT_CA_PRINCIPAL$p() : CertificatesKt.getDEFAULT_PRINCIPAL());
                            String[] stringArray2 = new String[]{"127.0.0.1", "localhost"};
                            $this$certificate.setDomains(CollectionsKt.listOf(stringArray2));
                        }
                    });
                }
            });
            keyStore2.setCertificateEntry(keyAlias + "Cert", keyStore2.getCertificate(keyAlias));
            File file3 = file2;
            if (file3 == null) break block0;
            File it = file3;
            boolean bl = false;
            BuildersKt.saveToFile(keyStore2, it, jksPassword);
        }
        return keyStore2;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(File file2, String string, String string2, String string3, String string4, int n, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file2 = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(file2, string, string2, string3, string4, n, keyType);
    }

    @NotNull
    public static final X509Certificate generateX509Certificate-Tu6dINM(@NotNull X500Principal subject, @NotNull X500Principal issuer, @NotNull PublicKey publicKey, @NotNull KeyPair signerKeyPair, @NotNull String algorithm, long validityDuration, @NotNull KeyType keyType, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter(subject, "subject");
        Intrinsics.checkNotNullParameter(issuer, "issuer");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(signerKeyPair, "signerKeyPair");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter((Object)keyType, "keyType");
        Intrinsics.checkNotNullParameter(domains, "domains");
        Intrinsics.checkNotNullParameter(ipAddresses, "ipAddresses");
        Instant now = Instant.now();
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$generateX509Certificate_Tu6dINM_u24lambda_u241 = builder$iv;
            boolean bl = false;
            long l = validityDuration;
            int n = Duration.getNanosecondsComponent-impl(l);
            long l2 = Duration.getInWholeSeconds-impl(l);
            java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue(duration, "toJavaDuration-LRDsOJo");
            Instant instant = now.plus(duration);
            Intrinsics.checkNotNullExpressionValue(now, "now");
            Intrinsics.checkNotNullExpressionValue(instant, "plus(validityDuration.toJavaDuration())");
            CertificatesKt.writeCertificate($this$generateX509Certificate_Tu6dINM_u24lambda_u241, issuer, subject, publicKey, algorithm, now, instant, domains, ipAddresses, signerKeyPair, keyType);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        byte[] certificateBytes = io.ktor.utils.io.core.StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
        Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateBytes));
        cert.verify(signerKeyPair.getPublic());
        Intrinsics.checkNotNull(cert, "null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)cert;
    }

    public static /* synthetic */ X509Certificate generateX509Certificate-Tu6dINM$default(X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, KeyPair keyPair, String string, long l, KeyType keyType, List list, List list2, int n, Object object) {
        if ((n & 0x20) != 0) {
            l = DurationKt.toDuration(3, DurationUnit.DAYS);
        }
        if ((n & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        if ((n & 0x80) != 0) {
            String[] stringArray = new String[]{"127.0.0.1", "localhost"};
            list = CollectionsKt.listOf(stringArray);
        }
        if ((n & 0x100) != 0) {
            list2 = CollectionsKt.listOf(Inet4Address.getByName("127.0.0.1"));
        }
        return CertificatesKt.generateX509Certificate-Tu6dINM(x500Principal, x500Principal2, publicKey, keyPair, string, l, keyType, list, list2);
    }

    @NotNull
    public static final KeyStore generateCertificate(@NotNull KeyStore $this$generateCertificate, @Nullable File file2, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull String caKeyAlias, @NotNull String caPassword, @NotNull KeyType keyType) {
        KeyStore keyStore2;
        block0: {
            Intrinsics.checkNotNullParameter($this$generateCertificate, "<this>");
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            Intrinsics.checkNotNullParameter(keyAlias, "keyAlias");
            Intrinsics.checkNotNullParameter(keyPassword, "keyPassword");
            Intrinsics.checkNotNullParameter(jksPassword, "jksPassword");
            Intrinsics.checkNotNullParameter(caKeyAlias, "caKeyAlias");
            Intrinsics.checkNotNullParameter(caPassword, "caPassword");
            Intrinsics.checkNotNullParameter((Object)keyType, "keyType");
            Certificate caCert = $this$generateCertificate.getCertificate(caKeyAlias);
            PublicKey publicKey = caCert.getPublicKey();
            char[] cArray = caPassword.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            Key key2 = $this$generateCertificate.getKey(caKeyAlias, cArray);
            Intrinsics.checkNotNull(key2, "null cannot be cast to non-null type java.security.PrivateKey");
            KeyPair caKeys = new KeyPair(publicKey, (PrivateKey)key2);
            keyStore2 = BuildersKt.buildKeyStore((Function1<? super KeyStoreBuilder, Unit>)new Function1<KeyStoreBuilder, Unit>(keyAlias, algorithm, keyPassword, keySizeInBits, keyType, caKeys, caCert){
                final /* synthetic */ String $keyAlias;
                final /* synthetic */ String $algorithm;
                final /* synthetic */ String $keyPassword;
                final /* synthetic */ int $keySizeInBits;
                final /* synthetic */ KeyType $keyType;
                final /* synthetic */ KeyPair $caKeys;
                final /* synthetic */ Certificate $caCert;
                {
                    this.$keyAlias = $keyAlias;
                    this.$algorithm = $algorithm;
                    this.$keyPassword = $keyPassword;
                    this.$keySizeInBits = $keySizeInBits;
                    this.$keyType = $keyType;
                    this.$caKeys = $caKeys;
                    this.$caCert = $caCert;
                    super(1);
                }

                public final void invoke(@NotNull KeyStoreBuilder $this$buildKeyStore) {
                    Intrinsics.checkNotNullParameter($this$buildKeyStore, "$this$buildKeyStore");
                    $this$buildKeyStore.certificate(this.$keyAlias, (Function1<? super CertificateBuilder, Unit>)new Function1<CertificateBuilder, Unit>(this.$algorithm, this.$keyPassword, this.$keySizeInBits, this.$keyType, this.$caKeys, this.$caCert){
                        final /* synthetic */ String $algorithm;
                        final /* synthetic */ String $keyPassword;
                        final /* synthetic */ int $keySizeInBits;
                        final /* synthetic */ KeyType $keyType;
                        final /* synthetic */ KeyPair $caKeys;
                        final /* synthetic */ Certificate $caCert;
                        {
                            this.$algorithm = $algorithm;
                            this.$keyPassword = $keyPassword;
                            this.$keySizeInBits = $keySizeInBits;
                            this.$keyType = $keyType;
                            this.$caKeys = $caKeys;
                            this.$caCert = $caCert;
                            super(1);
                        }

                        public final void invoke(@NotNull CertificateBuilder $this$certificate) {
                            Intrinsics.checkNotNullParameter($this$certificate, "$this$certificate");
                            String[] stringArray = new String[]{"with"};
                            List list = StringsKt.split$default((CharSequence)this.$algorithm, stringArray, false, 0, 6, null);
                            String hashName = (String)list.get(0);
                            String signName = (String)list.get(1);
                            $this$certificate.setHash(HashAlgorithm.valueOf(hashName));
                            $this$certificate.setSign(SignatureAlgorithm.valueOf(signName));
                            $this$certificate.setPassword(this.$keyPassword);
                            $this$certificate.setKeySizeInBits(this.$keySizeInBits);
                            $this$certificate.setKeyType(this.$keyType);
                            $this$certificate.setSubject(CertificatesKt.getDEFAULT_PRINCIPAL());
                            String[] stringArray2 = new String[]{"127.0.0.1", "localhost"};
                            $this$certificate.setDomains(CollectionsKt.listOf(stringArray2));
                            Certificate certificate = this.$caCert;
                            Intrinsics.checkNotNullExpressionValue(certificate, "caCert");
                            $this$certificate.signWith(this.$caKeys, certificate, CertificatesKt.access$getDEFAULT_CA_PRINCIPAL$p());
                        }
                    });
                }
            });
            File file3 = file2;
            if (file3 == null) break block0;
            File it = file3;
            boolean bl = false;
            BuildersKt.saveToFile(keyStore2, it, jksPassword);
        }
        return keyStore2;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(KeyStore keyStore2, File file2, String string, String string2, String string3, String string4, int n, String string5, String string6, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file2 = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            string5 = "mykey";
        }
        if ((n2 & 0x80) != 0) {
            string6 = "changeit";
        }
        if ((n2 & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(keyStore2, file2, string, string2, string3, string4, n, string5, string6, keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore trustStore(@NotNull KeyStore $this$trustStore, @Nullable File file2, @NotNull char[] password) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter($this$trustStore, "<this>");
        Intrinsics.checkNotNullParameter(password, "password");
        KeyStore keyStore2 = KeyStore.getInstance("JKS");
        Intrinsics.checkNotNull(keyStore2);
        KeyStore trustStore = keyStore2;
        trustStore.load(null, null);
        Enumeration<String> enumeration = $this$trustStore.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, "aliases()");
        ArrayList<String> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, "list(this)");
        Iterable iterable = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Certificate cert;
            String alias = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue($this$trustStore.getCertificate(alias), "getCertificate(alias)");
            trustStore.setCertificateEntry(alias, cert);
        }
        File file3 = file2;
        if (file3 != null && (file3 = file3.getParentFile()) != null) {
            file3.mkdirs();
        }
        if (file2 != null) {
            Closeable $this$use$iv = new FileOutputStream(file2);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileOutputStream it = (FileOutputStream)$this$use$iv;
                boolean bl = false;
                trustStore.store(it, password);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable first$iv) {
                try {
                    try {
                        closed$iv = true;
                        $this$use$iv.close();
                    }
                    catch (Throwable second$iv) {
                        CloseableJVMKt.addSuppressedInternal(first$iv, second$iv);
                    }
                    throw first$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        return trustStore;
    }

    public static /* synthetic */ KeyStore trustStore$default(KeyStore keyStore2, File file2, char[] cArray, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = null;
        }
        if ((n & 2) != 0) {
            char[] cArray2 = "changeit".toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray2, "this as java.lang.String).toCharArray()");
            cArray = cArray2;
        }
        return CertificatesKt.trustStore(keyStore2, file2, cArray);
    }

    @NotNull
    public static final List<TrustManager> getTrustManagers(@NotNull KeyStore $this$trustManagers) {
        TrustManagerFactory trustManagerFactory;
        Intrinsics.checkNotNullParameter($this$trustManagers, "<this>");
        TrustManagerFactory $this$_get_trustManagers__u24lambda_u245 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        $this$_get_trustManagers__u24lambda_u245.init($this$trustManagers);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue(trustManagerArray, "getInstance(TrustManager\u2026Managers) }.trustManagers");
        return ArraysKt.toList((Object[])trustManagerArray);
    }

    private static final void writeX509Info(BytePacketBuilder $this$writeX509Info, String algorithm, X500Principal issuer, X500Principal subject, PublicKey publicKey, Instant validFrom, Instant validUntil, List<String> domains, List<? extends InetAddress> ipAddresses, KeyType keyType) {
        BigInteger version2 = new BigInteger(64, new SecureRandom());
        CertificatesKt.writeDerSequence($this$writeX509Info, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(version2, algorithm, issuer, subject, publicKey, validFrom, validUntil, keyType, domains, ipAddresses){
            final /* synthetic */ BigInteger $version;
            final /* synthetic */ String $algorithm;
            final /* synthetic */ X500Principal $issuer;
            final /* synthetic */ X500Principal $subject;
            final /* synthetic */ PublicKey $publicKey;
            final /* synthetic */ Instant $validFrom;
            final /* synthetic */ Instant $validUntil;
            final /* synthetic */ KeyType $keyType;
            final /* synthetic */ List<String> $domains;
            final /* synthetic */ List<InetAddress> $ipAddresses;
            {
                this.$version = $version;
                this.$algorithm = $algorithm;
                this.$issuer = $issuer;
                this.$subject = $subject;
                this.$publicKey = $publicKey;
                this.$validFrom = $validFrom;
                this.$validUntil = $validUntil;
                this.$keyType = $keyType;
                this.$domains = $domains;
                this.$ipAddresses = $ipAddresses;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                ByteReadPacket byteReadPacket;
                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                CertificatesKt.access$writeVersion($this$writeDerSequence, 2);
                CertificatesKt.access$writeAsnInt($this$writeDerSequence, this.$version);
                CertificatesKt.access$writeAlgorithmIdentifier($this$writeDerSequence, this.$algorithm);
                CertificatesKt.access$writeX500Principal($this$writeDerSequence, this.$issuer);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this.$validFrom, this.$validUntil){
                    final /* synthetic */ Instant $validFrom;
                    final /* synthetic */ Instant $validUntil;
                    {
                        this.$validFrom = $validFrom;
                        this.$validUntil = $validUntil;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                        CertificatesKt.access$writeDerUTCTime($this$writeDerSequence, this.$validFrom);
                        CertificatesKt.access$writeDerGeneralizedTime($this$writeDerSequence, this.$validUntil);
                    }
                });
                CertificatesKt.access$writeX500Principal($this$writeDerSequence, this.$subject);
                Output output2 = $this$writeDerSequence;
                byte[] byArray = this.$publicKey.getEncoded();
                Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
                OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                $this$writeDerSequence.writeByte((byte)-93);
                KeyType keyType = this.$keyType;
                List<String> list = this.$domains;
                List<InetAddress> list2 = this.$ipAddresses;
                boolean $i$f$buildPacket = false;
                BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
                try {
                    BytePacketBuilder $this$invoke_u24lambda_u240 = builder$iv;
                    boolean bl = false;
                    CertificatesKt.access$writeDerSequence($this$invoke_u24lambda_u240, new Function1<BytePacketBuilder, Unit>(keyType, list, list2){
                        final /* synthetic */ KeyType $keyType;
                        final /* synthetic */ List<String> $domains;
                        final /* synthetic */ List<InetAddress> $ipAddresses;
                        {
                            this.$keyType = $keyType;
                            this.$domains = $domains;
                            this.$ipAddresses = $ipAddresses;
                            super(1);
                        }

                        public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                            Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                            switch (writeX509Info.extensions.1.WhenMappings.$EnumSwitchMapping$0[this.$keyType.ordinal()]) {
                                case 1: {
                                    CertificatesKt.access$caExtension($this$writeDerSequence);
                                    break;
                                }
                                case 2: {
                                    CertificatesKt.access$extKeyUsage($this$writeDerSequence, writeX509Info.extensions.1.1.INSTANCE);
                                    CertificatesKt.access$subjectAlternativeNames($this$writeDerSequence, this.$domains, this.$ipAddresses);
                                    break;
                                }
                                case 3: {
                                    CertificatesKt.access$extKeyUsage($this$writeDerSequence, writeX509Info.extensions.1.2.INSTANCE);
                                }
                            }
                        }
                    });
                    byteReadPacket = builder$iv.build();
                }
                catch (Throwable t$iv) {
                    builder$iv.release();
                    throw t$iv;
                }
                ByteReadPacket extensions2 = byteReadPacket;
                CertificatesKt.access$writeDerLength($this$writeDerSequence, (int)extensions2.getRemaining());
                $this$writeDerSequence.writePacket(extensions2);
            }
        });
    }

    static /* synthetic */ void writeX509Info$default(BytePacketBuilder bytePacketBuilder, String string, X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, Instant instant, Instant instant2, List list, List list2, KeyType keyType, int n, Object object) {
        if ((n & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeX509Info(bytePacketBuilder, string, x500Principal, x500Principal2, publicKey, instant, instant2, list, list2, keyType);
    }

    private static final void extKeyUsage(BytePacketBuilder $this$extKeyUsage, Function1<? super BytePacketBuilder, Unit> content2) {
        CertificatesKt.writeDerSequence($this$extKeyUsage, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(content2){
            final /* synthetic */ Function1<BytePacketBuilder, Unit> $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getExtKeyUsage());
                CertificatesKt.access$writeDerOctetString($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this.$content){
                    final /* synthetic */ Function1<BytePacketBuilder, Unit> $content;
                    {
                        this.$content = $content;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerOctetString) {
                        Intrinsics.checkNotNullParameter($this$writeDerOctetString, "$this$writeDerOctetString");
                        this.$content.invoke($this$writeDerOctetString);
                    }
                });
            }
        });
    }

    private static final void clientAuth(BytePacketBuilder $this$clientAuth) {
        CertificatesKt.writeDerSequence($this$clientAuth, clientAuth.1.INSTANCE);
    }

    private static final void serverAuth(BytePacketBuilder $this$serverAuth) {
        CertificatesKt.writeDerSequence($this$serverAuth, serverAuth.1.INSTANCE);
    }

    private static final void subjectAlternativeNames(BytePacketBuilder $this$subjectAlternativeNames, List<String> domains, List<? extends InetAddress> ipAddresses) {
        CertificatesKt.writeDerSequence($this$subjectAlternativeNames, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(domains, ipAddresses){
            final /* synthetic */ List<String> $domains;
            final /* synthetic */ List<InetAddress> $ipAddresses;
            {
                this.$domains = $domains;
                this.$ipAddresses = $ipAddresses;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getSubjectAltName());
                CertificatesKt.access$writeDerOctetString($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this.$domains, this.$ipAddresses){
                    final /* synthetic */ List<String> $domains;
                    final /* synthetic */ List<InetAddress> $ipAddresses;
                    {
                        this.$domains = $domains;
                        this.$ipAddresses = $ipAddresses;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerOctetString) {
                        Intrinsics.checkNotNullParameter($this$writeDerOctetString, "$this$writeDerOctetString");
                        CertificatesKt.access$writeDerSequence($this$writeDerOctetString, new Function1<BytePacketBuilder, Unit>(this.$domains, this.$ipAddresses){
                            final /* synthetic */ List<String> $domains;
                            final /* synthetic */ List<InetAddress> $ipAddresses;
                            {
                                this.$domains = $domains;
                                this.$ipAddresses = $ipAddresses;
                                super(1);
                            }

                            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                                for (String domain : this.$domains) {
                                    CertificatesKt.access$writeX509Extension($this$writeDerSequence, 2, new Function1<BytePacketBuilder, Unit>(domain){
                                        final /* synthetic */ String $domain;
                                        {
                                            this.$domain = $domain;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                            byte[] byArray;
                                            Intrinsics.checkNotNullParameter($this$writeX509Extension, "$this$writeX509Extension");
                                            Output output2 = $this$writeX509Extension;
                                            String $this$toByteArray_u24default$iv = this.$domain;
                                            Charset charset$iv = Charsets.UTF_8;
                                            boolean $i$f$toByteArray = false;
                                            if (Intrinsics.areEqual(charset$iv, Charsets.UTF_8)) {
                                                byArray = StringsKt.encodeToByteArray($this$toByteArray_u24default$iv);
                                            } else {
                                                CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                                                Intrinsics.checkNotNullExpressionValue(charsetEncoder, "charset.newEncoder()");
                                                byArray = CharsetJVMKt.encodeToByteArray(charsetEncoder, $this$toByteArray_u24default$iv, 0, $this$toByteArray_u24default$iv.length());
                                            }
                                            OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                                        }
                                    });
                                }
                                for (InetAddress ip : this.$ipAddresses) {
                                    CertificatesKt.access$writeX509Extension($this$writeDerSequence, 7, new Function1<BytePacketBuilder, Unit>(ip){
                                        final /* synthetic */ InetAddress $ip;
                                        {
                                            this.$ip = $ip;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull BytePacketBuilder $this$writeX509Extension) {
                                            Intrinsics.checkNotNullParameter($this$writeX509Extension, "$this$writeX509Extension");
                                            Output output2 = $this$writeX509Extension;
                                            byte[] byArray = this.$ip.getAddress();
                                            Intrinsics.checkNotNullExpressionValue(byArray, "ip.address");
                                            OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static final void caExtension(BytePacketBuilder $this$caExtension) {
        CertificatesKt.writeDerSequence($this$caExtension, caExtension.1.INSTANCE);
    }

    private static final void writeAlgorithmIdentifier(BytePacketBuilder $this$writeAlgorithmIdentifier, String algorithm) {
        CertificatesKt.writeDerSequence($this$writeAlgorithmIdentifier, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(algorithm){
            final /* synthetic */ String $algorithm;
            {
                this.$algorithm = $algorithm;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                OID oid = OID.Companion.fromAlgorithm(this.$algorithm);
                CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, oid);
                CertificatesKt.access$writeDerNull($this$writeDerSequence);
            }
        });
    }

    private static final void writeX509Extension(BytePacketBuilder $this$writeX509Extension, int id, Function1<? super BytePacketBuilder, Unit> builder2) {
        ByteReadPacket byteReadPacket;
        $this$writeX509Extension.writeByte((byte)(0x80 | id));
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeX509Extension_u24lambda_u246 = builder$iv;
            boolean bl = false;
            builder2.invoke($this$writeX509Extension_u24lambda_u246);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet2 = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeX509Extension, (int)packet2.getRemaining());
        $this$writeX509Extension.writePacket(packet2);
    }

    private static final void writeX500Principal(BytePacketBuilder $this$writeX500Principal, X500Principal dName) {
        Output output2 = $this$writeX500Principal;
        byte[] byArray = dName.getEncoded();
        Intrinsics.checkNotNullExpressionValue(byArray, "dName.encoded");
        OutputKt.writeFully$default(output2, byArray, 0, 0, 6, null);
    }

    private static final void writeCertificate(BytePacketBuilder $this$writeCertificate, X500Principal issuer, X500Principal subject, PublicKey publicKey, String algorithm, Instant validFrom, Instant validUntil, List<String> domains, List<? extends InetAddress> ipAddresses, KeyPair signerKeyPair, KeyType keyType) {
        ByteReadPacket byteReadPacket;
        if (!(validFrom.compareTo(validUntil) < 0)) {
            boolean $i$a$-require-CertificatesKt$writeCertificate$22 = false;
            String $i$a$-require-CertificatesKt$writeCertificate$22 = "validFrom must be before validUntil";
            throw new IllegalArgumentException($i$a$-require-CertificatesKt$writeCertificate$22.toString());
        }
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeCertificate_u24lambda_u248 = builder$iv;
            boolean bl = false;
            CertificatesKt.writeX509Info($this$writeCertificate_u24lambda_u248, algorithm, issuer, subject, publicKey, validFrom, validUntil, domains, ipAddresses, keyType);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket certInfo = byteReadPacket;
        byte[] certInfoBytes = io.ktor.utils.io.core.StringsKt.readBytes$default(certInfo, 0, 1, null);
        Signature signature2 = Signature.getInstance(algorithm);
        signature2.initSign(signerKeyPair.getPrivate());
        signature2.update(certInfoBytes);
        byte[] signed = signature2.sign();
        CertificatesKt.writeDerSequence($this$writeCertificate, (Function1<? super BytePacketBuilder, Unit>)new Function1<BytePacketBuilder, Unit>(certInfoBytes, signed, algorithm){
            final /* synthetic */ byte[] $certInfoBytes;
            final /* synthetic */ byte[] $signed;
            final /* synthetic */ String $algorithm;
            {
                this.$certInfoBytes = $certInfoBytes;
                this.$signed = $signed;
                this.$algorithm = $algorithm;
                super(1);
            }

            public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                OutputKt.writeFully$default((Output)$this$writeDerSequence, this.$certInfoBytes, 0, 0, 6, null);
                CertificatesKt.access$writeDerSequence($this$writeDerSequence, new Function1<BytePacketBuilder, Unit>(this.$algorithm){
                    final /* synthetic */ String $algorithm;
                    {
                        this.$algorithm = $algorithm;
                        super(1);
                    }

                    public final void invoke(@NotNull BytePacketBuilder $this$writeDerSequence) {
                        Intrinsics.checkNotNullParameter($this$writeDerSequence, "$this$writeDerSequence");
                        CertificatesKt.access$writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.fromAlgorithm(this.$algorithm));
                        CertificatesKt.access$writeDerNull($this$writeDerSequence);
                    }
                });
                Intrinsics.checkNotNullExpressionValue(this.$signed, "signed");
                CertificatesKt.writeDerBitString$default($this$writeDerSequence, this.$signed, 0, 2, null);
            }
        });
    }

    static /* synthetic */ void writeCertificate$default(BytePacketBuilder bytePacketBuilder, X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, String string, Instant instant, Instant instant2, List list, List list2, KeyPair keyPair, KeyType keyType, int n, Object object) {
        if ((n & 0x200) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeCertificate(bytePacketBuilder, x500Principal, x500Principal2, publicKey, string, instant, instant2, list, list2, keyPair, keyType);
    }

    private static final void writeVersion(BytePacketBuilder $this$writeVersion, int v) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeVersion, 2, 0, false);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeVersion_u24lambda_u249 = builder$iv;
            boolean bl = false;
            CertificatesKt.writeAsnInt($this$writeVersion_u24lambda_u249, v);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded2 = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeVersion, (int)encoded2.getRemaining());
        $this$writeVersion.writePacket(encoded2);
    }

    static /* synthetic */ void writeVersion$default(BytePacketBuilder bytePacketBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        CertificatesKt.writeVersion(bytePacketBuilder, n);
    }

    private static final void writeDerOctetString(BytePacketBuilder $this$writeDerOctetString, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerOctetString_u24lambda_u2410 = builder$iv;
            boolean bl = false;
            block2.invoke($this$writeDerOctetString_u24lambda_u2410);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerOctetString, 0, 4, true);
        CertificatesKt.writeDerLength($this$writeDerOctetString, (int)sub.getRemaining());
        $this$writeDerOctetString.writePacket(sub);
    }

    private static final void writeDerBitString(BytePacketBuilder $this$writeDerBitString, byte[] array, int unused) {
        if (!(0 <= unused ? unused < 8 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, array.length + 1);
        $this$writeDerBitString.writeByte((byte)unused);
        OutputKt.writeFully$default((Output)$this$writeDerBitString, array, 0, 0, 6, null);
    }

    static /* synthetic */ void writeDerBitString$default(BytePacketBuilder bytePacketBuilder, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        CertificatesKt.writeDerBitString(bytePacketBuilder, byArray, n);
    }

    private static final void writeDerUTCTime(BytePacketBuilder $this$writeDerUTCTime, Instant date) {
        String string = DateTimeFormatter.ofPattern("yyMMddHHmmss'Z'").format(date.atZone(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue(string, "ofPattern(\"yyMMddHHmmss'\u2026e.atZone(ZoneOffset.UTC))");
        CertificatesKt.writeDerUTF8String($this$writeDerUTCTime, string, 23);
    }

    private static final void writeDerGeneralizedTime(BytePacketBuilder $this$writeDerGeneralizedTime, Instant date) {
        String string = DateTimeFormatter.ofPattern("yyyyMMddHHmmss'Z'").format(date.atZone(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue(string, "ofPattern(\"yyyyMMddHHmms\u2026e.atZone(ZoneOffset.UTC))");
        CertificatesKt.writeDerUTF8String($this$writeDerGeneralizedTime, string, 24);
    }

    private static final void writeDerUTF8String(BytePacketBuilder $this$writeDerUTF8String, String s, int type2) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerUTF8String_u24lambda_u2411 = builder$iv;
            boolean bl = false;
            io.ktor.utils.io.core.StringsKt.writeText$default((Output)$this$writeDerUTF8String_u24lambda_u2411, s, 0, 0, null, 14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerUTF8String, 0, type2, true);
        CertificatesKt.writeDerLength($this$writeDerUTF8String, (int)sub.getRemaining());
        $this$writeDerUTF8String.writePacket(sub);
    }

    static /* synthetic */ void writeDerUTF8String$default(BytePacketBuilder bytePacketBuilder, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        CertificatesKt.writeDerUTF8String(bytePacketBuilder, string, n);
    }

    private static final void writeDerNull(BytePacketBuilder $this$writeDerNull) {
        OutputPrimitivesKt.writeShort($this$writeDerNull, (short)1280);
    }

    private static final void writeDerSequence(BytePacketBuilder $this$writeDerSequence, Function1<? super BytePacketBuilder, Unit> block2) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeDerSequence_u24lambda_u2412 = builder$iv;
            boolean bl = false;
            block2.invoke($this$writeDerSequence_u24lambda_u2412);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket sub = byteReadPacket;
        CertificatesKt.writeDerType($this$writeDerSequence, 0, 16, false);
        CertificatesKt.writeDerLength($this$writeDerSequence, (int)sub.getRemaining());
        $this$writeDerSequence.writePacket(sub);
    }

    private static final void writeDerObjectIdentifier(BytePacketBuilder $this$writeDerObjectIdentifier, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($this$writeDerObjectIdentifier, identifier.getAsArray());
    }

    /*
     * Unable to fully structure code
     */
    private static final void writeDerObjectIdentifier(BytePacketBuilder $this$writeDerObjectIdentifier, int[] identifier) {
        if (!(identifier.length >= 2)) {
            var3_2 = "Failed requirement.";
            throw new IllegalArgumentException(var3_2.toString());
        }
        var2_6 = identifier[0];
        if (!(0 <= var2_6 ? var2_6 < 3 : false)) {
            var3_3 = "Failed requirement.";
            throw new IllegalArgumentException(var3_3.toString());
        }
        if (identifier[0] == 2) ** GOTO lbl-1000
        var2_6 = identifier[1];
        v0 = 0 <= var2_6 ? var2_6 < 40 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            var3_4 = "Failed requirement.";
            throw new IllegalArgumentException(var3_4.toString());
        }
        $i$f$buildPacket = false;
        builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            $this$writeDerObjectIdentifier_u24lambda_u2413 = builder$iv;
            $i$a$-buildPacket-CertificatesKt$writeDerObjectIdentifier$sub$1 = false;
            CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2413, identifier[0] * 40 + identifier[1]);
            i = 2;
            var8_13 = ArraysKt.getLastIndex(identifier);
            if (i <= var8_13) {
                while (true) {
                    CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2413, identifier[i]);
                    if (i == var8_13) break;
                    ++i;
                }
            }
            v2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        sub = v2;
        CertificatesKt.writeDerType($this$writeDerObjectIdentifier, 0, 6, true);
        CertificatesKt.writeDerLength($this$writeDerObjectIdentifier, (int)sub.getRemaining());
        $this$writeDerObjectIdentifier.writePacket(sub);
    }

    private static final void writeAsnInt(BytePacketBuilder $this$writeAsnInt, BigInteger value) {
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        byte[] encoded2 = value.toByteArray();
        CertificatesKt.writeDerLength($this$writeAsnInt, encoded2.length);
        Output output2 = $this$writeAsnInt;
        Intrinsics.checkNotNullExpressionValue(encoded2, "encoded");
        OutputKt.writeFully$default(output2, encoded2, 0, 0, 6, null);
    }

    private static final void writeAsnInt(BytePacketBuilder $this$writeAsnInt, int value) {
        ByteReadPacket byteReadPacket;
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeAsnInt_u24lambda_u2414 = builder$iv;
            boolean bl = false;
            boolean skip = true;
            for (int idx = 0; idx < 4; ++idx) {
                int part2 = value >>> (4 - idx - 1) * 8 & 0xFF;
                if (part2 == 0 && skip) continue;
                skip = false;
                $this$writeAsnInt_u24lambda_u2414.writeByte((byte)part2);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket encoded2 = byteReadPacket;
        CertificatesKt.writeDerLength($this$writeAsnInt, (int)encoded2.getRemaining());
        $this$writeAsnInt.writePacket(encoded2);
    }

    private static final void writeDerLength(BytePacketBuilder $this$writeDerLength, int length) {
        if (!(length >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length <= 127) {
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 255) {
            $this$writeDerLength.writeByte((byte)-127);
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 65535) {
            $this$writeDerLength.writeByte((byte)-126);
            $this$writeDerLength.writeByte((byte)(length >>> 8));
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 0xFFFFFF) {
            $this$writeDerLength.writeByte((byte)-125);
            $this$writeDerLength.writeByte((byte)(length >>> 16));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        } else {
            $this$writeDerLength.writeByte((byte)-124);
            $this$writeDerLength.writeByte((byte)(length >>> 24));
            $this$writeDerLength.writeByte((byte)(length >>> 16 & 0xFF));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        }
    }

    private static final void writeDerType(BytePacketBuilder $this$writeDerType, int kind, int typeIdentifier, boolean simpleType2) {
        if (!(0 <= kind ? kind < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(typeIdentifier >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl = 0 <= typeIdentifier ? typeIdentifier < 31 : false;
        if (bl) {
            int singleByte = kind << 6 | typeIdentifier | (simpleType2 ? 0 : 32);
            byte byteValue = (byte)singleByte;
            $this$writeDerType.writeByte(byteValue);
        } else {
            int firstByte = kind << 6 | 0x1F | (simpleType2 ? 0 : 32);
            $this$writeDerType.writeByte((byte)firstByte);
            CertificatesKt.writeDerInt($this$writeDerType, typeIdentifier);
        }
    }

    private static final int derLength(int $this$derLength) {
        if (!($this$derLength >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$derLength == 0) {
            return 0;
        }
        int mask = 127;
        int byteCount = 1;
        while (($this$derLength & mask) != $this$derLength) {
            mask |= mask << 7;
            ++byteCount;
        }
        return byteCount;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeDerBoolean(BytePacketBuilder $this$writeDerBoolean, boolean value) {
        void $this$writeUByte_u2dEK_u2d6454$iv;
        CertificatesKt.writeDerType($this$writeDerBoolean, 0, 1, true);
        CertificatesKt.writeDerLength($this$writeDerBoolean, 1);
        Output output2 = $this$writeDerBoolean;
        byte v$iv = CertificatesKt.toUByte(value);
        boolean bl = false;
        $this$writeUByte_u2dEK_u2d6454$iv.writeByte(v$iv);
    }

    private static final byte toUByte(boolean $this$toUByte) {
        return $this$toUByte ? UByte.constructor-impl((byte)255) : UByte.constructor-impl((byte)0);
    }

    private static final void writeDerInt(BytePacketBuilder $this$writeDerInt, int value) {
        if (!(value >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int byteCount = CertificatesKt.derLength(value);
        for (int j = 0; j < byteCount; ++j) {
            int idx = j;
            boolean bl = false;
            int part2 = value >> (byteCount - idx - 1) * 7 & 0x7F;
            if (idx == byteCount - 1) {
                $this$writeDerInt.writeByte((byte)part2);
                continue;
            }
            $this$writeDerInt.writeByte((byte)(part2 | 0x80));
        }
    }

    public static final /* synthetic */ X500Principal access$getDEFAULT_CA_PRINCIPAL$p() {
        return DEFAULT_CA_PRINCIPAL;
    }

    public static final /* synthetic */ void access$writeVersion(BytePacketBuilder $receiver, int v) {
        CertificatesKt.writeVersion($receiver, v);
    }

    public static final /* synthetic */ void access$writeAsnInt(BytePacketBuilder $receiver, BigInteger value) {
        CertificatesKt.writeAsnInt($receiver, value);
    }

    public static final /* synthetic */ void access$writeAlgorithmIdentifier(BytePacketBuilder $receiver, String algorithm) {
        CertificatesKt.writeAlgorithmIdentifier($receiver, algorithm);
    }

    public static final /* synthetic */ void access$writeX500Principal(BytePacketBuilder $receiver, X500Principal dName) {
        CertificatesKt.writeX500Principal($receiver, dName);
    }

    public static final /* synthetic */ void access$writeDerSequence(BytePacketBuilder $receiver, Function1 block2) {
        CertificatesKt.writeDerSequence($receiver, block2);
    }

    public static final /* synthetic */ void access$writeDerUTCTime(BytePacketBuilder $receiver, Instant date) {
        CertificatesKt.writeDerUTCTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerGeneralizedTime(BytePacketBuilder $receiver, Instant date) {
        CertificatesKt.writeDerGeneralizedTime($receiver, date);
    }

    public static final /* synthetic */ void access$writeDerLength(BytePacketBuilder $receiver, int length) {
        CertificatesKt.writeDerLength($receiver, length);
    }

    public static final /* synthetic */ void access$caExtension(BytePacketBuilder $receiver) {
        CertificatesKt.caExtension($receiver);
    }

    public static final /* synthetic */ void access$extKeyUsage(BytePacketBuilder $receiver, Function1 content2) {
        CertificatesKt.extKeyUsage($receiver, content2);
    }

    public static final /* synthetic */ void access$serverAuth(BytePacketBuilder $receiver) {
        CertificatesKt.serverAuth($receiver);
    }

    public static final /* synthetic */ void access$subjectAlternativeNames(BytePacketBuilder $receiver, List domains, List ipAddresses) {
        CertificatesKt.subjectAlternativeNames($receiver, domains, ipAddresses);
    }

    public static final /* synthetic */ void access$clientAuth(BytePacketBuilder $receiver) {
        CertificatesKt.clientAuth($receiver);
    }

    public static final /* synthetic */ void access$writeDerObjectIdentifier(BytePacketBuilder $receiver, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($receiver, identifier);
    }

    public static final /* synthetic */ void access$writeDerOctetString(BytePacketBuilder $receiver, Function1 block2) {
        CertificatesKt.writeDerOctetString($receiver, block2);
    }

    public static final /* synthetic */ void access$writeX509Extension(BytePacketBuilder $receiver, int id, Function1 builder2) {
        CertificatesKt.writeX509Extension($receiver, id, builder2);
    }

    public static final /* synthetic */ void access$writeDerBoolean(BytePacketBuilder $receiver, boolean value) {
        CertificatesKt.writeDerBoolean($receiver, value);
    }

    public static final /* synthetic */ void access$writeDerNull(BytePacketBuilder $receiver) {
        CertificatesKt.writeDerNull($receiver);
    }
}

