/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OIDKt;
import io.ktor.network.tls.certificates.CertificateInfo;
import io.ktor.network.tls.certificates.CertificatesKt;
import io.ktor.network.tls.certificates.KeyType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001DB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\r\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b;J\u001e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u000204J\u0016\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020CR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006E"}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder;", "", "()V", "daysValid", "", "getDaysValid", "()J", "setDaysValid", "(J)V", "domains", "", "", "getDomains", "()Ljava/util/List;", "setDomains", "(Ljava/util/List;)V", "hash", "Lio/ktor/network/tls/extensions/HashAlgorithm;", "getHash", "()Lio/ktor/network/tls/extensions/HashAlgorithm;", "setHash", "(Lio/ktor/network/tls/extensions/HashAlgorithm;)V", "ipAddresses", "Ljava/net/InetAddress;", "getIpAddresses", "setIpAddresses", "issuer", "Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "keySizeInBits", "", "getKeySizeInBits", "()I", "setKeySizeInBits", "(I)V", "keyType", "Lio/ktor/network/tls/certificates/KeyType;", "getKeyType", "()Lio/ktor/network/tls/certificates/KeyType;", "setKeyType", "(Lio/ktor/network/tls/certificates/KeyType;)V", "password", "getPassword", "()Ljava/lang/String;", "setPassword", "(Ljava/lang/String;)V", "sign", "Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "getSign", "()Lio/ktor/network/tls/extensions/SignatureAlgorithm;", "setSign", "(Lio/ktor/network/tls/extensions/SignatureAlgorithm;)V", "subject", "Ljavax/security/auth/x500/X500Principal;", "getSubject", "()Ljavax/security/auth/x500/X500Principal;", "setSubject", "(Ljavax/security/auth/x500/X500Principal;)V", "build", "Lio/ktor/network/tls/certificates/CertificateInfo;", "build$ktor_network_tls_certificates", "signWith", "", "issuerKeyPair", "Ljava/security/KeyPair;", "issuerKeyCertificate", "Ljava/security/cert/Certificate;", "issuerName", "Ljava/security/cert/X509Certificate;", "CertificateIssuer", "ktor-network-tls-certificates"})
public final class CertificateBuilder {
    @NotNull
    private HashAlgorithm hash = HashAlgorithm.SHA1;
    @NotNull
    private SignatureAlgorithm sign = SignatureAlgorithm.RSA;
    public String password;
    @NotNull
    private X500Principal subject = CertificatesKt.getDEFAULT_PRINCIPAL();
    private long daysValid = 3L;
    private int keySizeInBits = 1024;
    @NotNull
    private KeyType keyType = KeyType.Server;
    @NotNull
    private List<String> domains = CollectionsKt.listOf("localhost");
    @NotNull
    private List<? extends InetAddress> ipAddresses = CollectionsKt.listOf(Inet4Address.getByName("127.0.0.1"));
    @Nullable
    private CertificateIssuer issuer;

    @NotNull
    public final HashAlgorithm getHash() {
        return this.hash;
    }

    public final void setHash(@NotNull HashAlgorithm hashAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)hashAlgorithm, "<set-?>");
        this.hash = hashAlgorithm;
    }

    @NotNull
    public final SignatureAlgorithm getSign() {
        return this.sign;
    }

    public final void setSign(@NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, "<set-?>");
        this.sign = signatureAlgorithm;
    }

    @NotNull
    public final String getPassword() {
        String string = this.password;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("password");
        return null;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.password = string;
    }

    @NotNull
    public final X500Principal getSubject() {
        return this.subject;
    }

    public final void setSubject(@NotNull X500Principal x500Principal) {
        Intrinsics.checkNotNullParameter(x500Principal, "<set-?>");
        this.subject = x500Principal;
    }

    public final long getDaysValid() {
        return this.daysValid;
    }

    public final void setDaysValid(long l) {
        this.daysValid = l;
    }

    public final int getKeySizeInBits() {
        return this.keySizeInBits;
    }

    public final void setKeySizeInBits(int n) {
        this.keySizeInBits = n;
    }

    @NotNull
    public final KeyType getKeyType() {
        return this.keyType;
    }

    public final void setKeyType(@NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)keyType, "<set-?>");
        this.keyType = keyType;
    }

    @NotNull
    public final List<String> getDomains() {
        return this.domains;
    }

    public final void setDomains(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.domains = list;
    }

    @NotNull
    public final List<InetAddress> getIpAddresses() {
        return this.ipAddresses;
    }

    public final void setIpAddresses(@NotNull List<? extends InetAddress> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.ipAddresses = list;
    }

    public final void signWith(@NotNull KeyPair issuerKeyPair, @NotNull X509Certificate issuerKeyCertificate) {
        Intrinsics.checkNotNullParameter(issuerKeyPair, "issuerKeyPair");
        Intrinsics.checkNotNullParameter(issuerKeyCertificate, "issuerKeyCertificate");
        X500Principal x500Principal = issuerKeyCertificate.getSubjectX500Principal();
        Intrinsics.checkNotNullExpressionValue(x500Principal, "issuerKeyCertificate.subjectX500Principal");
        this.issuer = new CertificateIssuer(x500Principal, issuerKeyPair, issuerKeyCertificate);
    }

    public final void signWith(@NotNull KeyPair issuerKeyPair, @NotNull Certificate issuerKeyCertificate, @NotNull X500Principal issuerName) {
        Intrinsics.checkNotNullParameter(issuerKeyPair, "issuerKeyPair");
        Intrinsics.checkNotNullParameter(issuerKeyCertificate, "issuerKeyCertificate");
        Intrinsics.checkNotNullParameter(issuerName, "issuerName");
        this.issuer = new CertificateIssuer(issuerName, issuerKeyPair, issuerKeyCertificate);
    }

    @NotNull
    public final CertificateInfo build$ktor_network_tls_certificates() {
        KeyPairGenerator keyPairGenerator;
        HashAndSign algorithm = new HashAndSign(this.hash, this.sign, null, 4, null);
        KeyPairGenerator $this$build_u24lambda_u240 = keyPairGenerator = KeyPairGenerator.getInstance(OIDKt.keysGenerationAlgorithm(algorithm.getName()));
        boolean bl = false;
        $this$build_u24lambda_u240.initialize(this.keySizeInBits);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Intrinsics.checkNotNull(keyPair);
        KeyPair keys2 = keyPair;
        Object object = this.issuer;
        if (object == null || (object = ((CertificateIssuer)object).getName()) == null) {
            object = this.subject;
        }
        Object object2 = object;
        X500Principal x500Principal = this.subject;
        PublicKey publicKey = keys2.getPublic();
        Object object3 = this.issuer;
        if (object3 == null || (object3 = ((CertificateIssuer)object3).getKeyPair()) == null) {
            object3 = keys2;
        }
        Object object4 = object3;
        String string = algorithm.getName();
        long l = DurationKt.toDuration(this.daysValid, DurationUnit.DAYS);
        KeyType keyType = this.keyType;
        List<String> list = this.domains;
        List<? extends InetAddress> list2 = this.ipAddresses;
        Intrinsics.checkNotNullExpressionValue(publicKey, "public");
        X509Certificate cert = CertificatesKt.generateX509Certificate-Tu6dINM(x500Principal, (X500Principal)object2, publicKey, (KeyPair)object4, string, l, keyType, list, list2);
        CertificateIssuer certificateIssuer = this.issuer;
        return new CertificateInfo(cert, keys2, this.getPassword(), certificateIssuer != null ? certificateIssuer.getKeyCertificate() : null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/ktor/network/tls/certificates/CertificateBuilder$CertificateIssuer;", "", "name", "Ljavax/security/auth/x500/X500Principal;", "keyPair", "Ljava/security/KeyPair;", "keyCertificate", "Ljava/security/cert/Certificate;", "(Ljavax/security/auth/x500/X500Principal;Ljava/security/KeyPair;Ljava/security/cert/Certificate;)V", "getKeyCertificate", "()Ljava/security/cert/Certificate;", "getKeyPair", "()Ljava/security/KeyPair;", "getName", "()Ljavax/security/auth/x500/X500Principal;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-network-tls-certificates"})
    private static final class CertificateIssuer {
        @NotNull
        private final X500Principal name;
        @NotNull
        private final KeyPair keyPair;
        @NotNull
        private final Certificate keyCertificate;

        public CertificateIssuer(@NotNull X500Principal name, @NotNull KeyPair keyPair, @NotNull Certificate keyCertificate) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(keyPair, "keyPair");
            Intrinsics.checkNotNullParameter(keyCertificate, "keyCertificate");
            this.name = name;
            this.keyPair = keyPair;
            this.keyCertificate = keyCertificate;
        }

        @NotNull
        public final X500Principal getName() {
            return this.name;
        }

        @NotNull
        public final KeyPair getKeyPair() {
            return this.keyPair;
        }

        @NotNull
        public final Certificate getKeyCertificate() {
            return this.keyCertificate;
        }

        @NotNull
        public final X500Principal component1() {
            return this.name;
        }

        @NotNull
        public final KeyPair component2() {
            return this.keyPair;
        }

        @NotNull
        public final Certificate component3() {
            return this.keyCertificate;
        }

        @NotNull
        public final CertificateIssuer copy(@NotNull X500Principal name, @NotNull KeyPair keyPair, @NotNull Certificate keyCertificate) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(keyPair, "keyPair");
            Intrinsics.checkNotNullParameter(keyCertificate, "keyCertificate");
            return new CertificateIssuer(name, keyPair, keyCertificate);
        }

        public static /* synthetic */ CertificateIssuer copy$default(CertificateIssuer certificateIssuer, X500Principal x500Principal, KeyPair keyPair, Certificate certificate, int n, Object object) {
            if ((n & 1) != 0) {
                x500Principal = certificateIssuer.name;
            }
            if ((n & 2) != 0) {
                keyPair = certificateIssuer.keyPair;
            }
            if ((n & 4) != 0) {
                certificate = certificateIssuer.keyCertificate;
            }
            return certificateIssuer.copy(x500Principal, keyPair, certificate);
        }

        @NotNull
        public String toString() {
            return "CertificateIssuer(name=" + this.name + ", keyPair=" + this.keyPair + ", keyCertificate=" + this.keyCertificate + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.keyPair.hashCode();
            result2 = result2 * 31 + this.keyCertificate.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CertificateIssuer)) {
                return false;
            }
            CertificateIssuer certificateIssuer = (CertificateIssuer)other;
            if (!Intrinsics.areEqual(this.name, certificateIssuer.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.keyPair, certificateIssuer.keyPair)) {
                return false;
            }
            return Intrinsics.areEqual(this.keyCertificate, certificateIssuer.keyCertificate);
        }
    }
}

