/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.NamedCurvesKt;
import io.ktor.network.tls.extensions.PointFormat;
import io.ktor.network.tls.extensions.PointFormatKt;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.OutputPrimitivesKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00042\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\"\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u001a$\u0010!\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u001a\u0014\u0010'\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010(\u001a\u00020$H\u0000\u001a\u001d\u0010)\u001a\u00020\u001a*\u00020*2\u0006\u0010+\u001a\u00020,H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-\u001a\u001f\u0010.\u001a\u00020\u001a*\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0000\u00a2\u0006\u0002\u00102\u001a>\u00103\u001a\u00020\u001a*\u00020\u001b2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00062\u0006\u0010%\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u00132\n\b\u0002\u00109\u001a\u0004\u0018\u00010\rH\u0000\u001a\u001c\u0010:\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0014\u0010=\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010>\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"MAX_CURVES_QUANTITY", "", "MAX_SERVER_NAME_LENGTH", "buildECCurvesExtension", "Lio/ktor/utils/io/core/ByteReadPacket;", "curves", "", "Lio/ktor/network/tls/extensions/NamedCurve;", "buildECPointFormatExtension", "formats", "Lio/ktor/network/tls/extensions/PointFormat;", "buildServerNameExtension", "name", "", "buildSignatureAlgorithmsExtension", "algorithms", "Lio/ktor/network/tls/extensions/HashAndSign;", "finished", "digest", "", "secretKey", "Ljavax/crypto/SecretKey;", "serverFinished", "handshakeHash", "length", "writeAligned", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "src", "fieldSize", "writeECPoint", "point", "Ljava/security/spec/ECPoint;", "writeEncryptedPreMasterSecret", "preSecret", "publicKey", "Ljava/security/PublicKey;", "random", "Ljava/security/SecureRandom;", "writePublicKeyUncompressed", "key", "writeRecord", "Lio/ktor/utils/io/ByteWriteChannel;", "record", "Lio/ktor/network/tls/TLSRecord;", "(Lio/ktor/utils/io/ByteWriteChannel;Lio/ktor/network/tls/TLSRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeTLSCertificates", "certificates", "", "Ljava/security/cert/X509Certificate;", "(Lio/ktor/utils/io/core/BytePacketBuilder;[Ljava/security/cert/X509Certificate;)V", "writeTLSClientHello", "version", "Lio/ktor/network/tls/TLSVersion;", "suites", "Lio/ktor/network/tls/CipherSuite;", "sessionId", "serverName", "writeTLSHandshakeType", "type", "Lio/ktor/network/tls/TLSHandshakeType;", "writeTripleByteLength", "value", "ktor-network-tls"})
public final class RenderKt {
    private static final int MAX_SERVER_NAME_LENGTH = 32762;
    private static final int MAX_CURVES_QUANTITY = 16382;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object writeRecord(@NotNull ByteWriteChannel var0, @NotNull TLSRecord var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof writeRecord.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super writeRecord.1>)var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RenderKt.writeRecord(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$writeRecord_u24lambda_u240 = record;
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = $this$writeRecord_u24lambda_u240;
                $continuation.label = 1;
                v0 = $this$writeRecord.writeByte((byte)$this$writeRecord_u24lambda_u240.getType().getCode(), $continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl27:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = $this$writeRecord_u24lambda_u240;
                $continuation.label = 2;
                v1 = $this$writeRecord.writeByte((byte)($this$writeRecord_u24lambda_u240.getVersion().getCode() >> 8), $continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl40:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = $this$writeRecord_u24lambda_u240;
                $continuation.label = 3;
                v2 = $this$writeRecord.writeByte((byte)$this$writeRecord_u24lambda_u240.getVersion().getCode(), $continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl53
            }
            case 3: {
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl53:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = $this$writeRecord_u24lambda_u240;
                $continuation.label = 4;
                v3 = $this$writeRecord.writeShort((short)$this$writeRecord_u24lambda_u240.getPacket().getRemaining(), $continuation);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl66
            }
            case 4: {
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl66:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = null;
                $continuation.label = 5;
                v4 = $this$writeRecord.writePacket($this$writeRecord_u24lambda_u240.getPacket(), $continuation);
                if (v4 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl78
            }
            case 5: {
                $i$a$-with-RenderKt$writeRecord$2 = false;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v4 = $result;
lbl78:
                // 2 sources

                $this$writeRecord.flush();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void writeTLSHandshakeType(@NotNull BytePacketBuilder $this$writeTLSHandshakeType, @NotNull TLSHandshakeType type2, int length) {
        Intrinsics.checkNotNullParameter($this$writeTLSHandshakeType, "<this>");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        if (length > 0xFFFFFF) {
            throw new TLSException("TLS handshake size limit exceeded: " + length, null, 2, null);
        }
        int v = type2.getCode() << 24 | length;
        OutputPrimitivesKt.writeInt($this$writeTLSHandshakeType, v);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeTLSClientHello(@NotNull BytePacketBuilder $this$writeTLSClientHello, @NotNull TLSVersion version2, @NotNull List<CipherSuite> suites, @NotNull byte[] random, @NotNull byte[] sessionId, @Nullable String serverName) {
        int n;
        Intrinsics.checkNotNullParameter($this$writeTLSClientHello, "<this>");
        Intrinsics.checkNotNullParameter((Object)version2, "version");
        Intrinsics.checkNotNullParameter(suites, "suites");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(sessionId, "sessionId");
        OutputPrimitivesKt.writeShort($this$writeTLSClientHello, (short)version2.getCode());
        OutputKt.writeFully$default((Output)$this$writeTLSClientHello, random, 0, 0, 6, null);
        int sessionIdLength = sessionId.length;
        if (sessionIdLength < 0 || sessionIdLength > 255 || sessionIdLength > sessionId.length) {
            throw new TLSException("Illegal sessionIdLength", null, 2, null);
        }
        $this$writeTLSClientHello.writeByte((byte)sessionIdLength);
        OutputKt.writeFully((Output)$this$writeTLSClientHello, sessionId, 0, sessionIdLength);
        OutputPrimitivesKt.writeShort($this$writeTLSClientHello, (short)(suites.size() * 2));
        for (CipherSuite suite : suites) {
            OutputPrimitivesKt.writeShort($this$writeTLSClientHello, suite.getCode());
        }
        $this$writeTLSClientHello.writeByte((byte)1);
        $this$writeTLSClientHello.writeByte((byte)0);
        ArrayList extensions2 = new ArrayList();
        ((Collection)extensions2).add(RenderKt.buildSignatureAlgorithmsExtension$default(null, 1, null));
        ((Collection)extensions2).add(RenderKt.buildECCurvesExtension$default(null, 1, null));
        ((Collection)extensions2).add(RenderKt.buildECPointFormatExtension$default(null, 1, null));
        String string = serverName;
        if (string != null) {
            String name = string;
            boolean bl = false;
            ((Collection)extensions2).add(RenderKt.buildServerNameExtension(name));
        }
        Iterable iterable = extensions2;
        Output output2 = $this$writeTLSClientHello;
        int name = 0;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            ByteReadPacket byteReadPacket = (ByteReadPacket)t;
            n = name;
            boolean bl = false;
            int n2 = (int)it.getRemaining();
            name = n + n2;
        }
        n = name;
        OutputPrimitivesKt.writeShort(output2, (short)n);
        for (ByteReadPacket e : extensions2) {
            Intrinsics.checkNotNullExpressionValue(e, "e");
            $this$writeTLSClientHello.writePacket(e);
        }
    }

    public static /* synthetic */ void writeTLSClientHello$default(BytePacketBuilder bytePacketBuilder, TLSVersion tLSVersion, List list, byte[] byArray, byte[] byArray2, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        RenderKt.writeTLSClientHello(bytePacketBuilder, tLSVersion, list, byArray, byArray2, string);
    }

    public static final void writeTLSCertificates(@NotNull BytePacketBuilder $this$writeTLSCertificates, @NotNull X509Certificate[] certificates) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$writeTLSCertificates, "<this>");
        Intrinsics.checkNotNullParameter(certificates, "certificates");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeTLSCertificates_u24lambda_u243 = builder$iv;
            boolean bl = false;
            for (X509Certificate certificate : certificates) {
                byte[] certificateBytes;
                Intrinsics.checkNotNull(certificate.getEncoded());
                RenderKt.writeTripleByteLength($this$writeTLSCertificates_u24lambda_u243, certificateBytes.length);
                OutputKt.writeFully$default((Output)$this$writeTLSCertificates_u24lambda_u243, certificateBytes, 0, 0, 6, null);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket chain = byteReadPacket;
        RenderKt.writeTripleByteLength($this$writeTLSCertificates, (int)chain.getRemaining());
        $this$writeTLSCertificates.writePacket(chain);
    }

    public static final void writeEncryptedPreMasterSecret(@NotNull BytePacketBuilder $this$writeEncryptedPreMasterSecret, @NotNull byte[] preSecret, @NotNull PublicKey publicKey, @NotNull SecureRandom random) {
        Intrinsics.checkNotNullParameter($this$writeEncryptedPreMasterSecret, "<this>");
        Intrinsics.checkNotNullParameter(preSecret, "preSecret");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        Intrinsics.checkNotNullParameter(random, "random");
        if (!(preSecret.length == 48)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Cipher cipher2 = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Intrinsics.checkNotNull(cipher2);
        Cipher rsaCipher = cipher2;
        rsaCipher.init(1, (Key)publicKey, random);
        byte[] encryptedSecret = rsaCipher.doFinal(preSecret);
        if (encryptedSecret.length > 65535) {
            throw new TLSException("Encrypted premaster secret is too long", null, 2, null);
        }
        OutputPrimitivesKt.writeShort($this$writeEncryptedPreMasterSecret, (short)encryptedSecret.length);
        Output output2 = $this$writeEncryptedPreMasterSecret;
        Intrinsics.checkNotNullExpressionValue(encryptedSecret, "encryptedSecret");
        OutputKt.writeFully$default(output2, encryptedSecret, 0, 0, 6, null);
    }

    @NotNull
    public static final ByteReadPacket finished(@NotNull byte[] digest, @NotNull SecretKey secretKey) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(secretKey, "secretKey");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$finished_u24lambda_u244 = builder$iv;
            boolean bl = false;
            byte[] prf = HashesKt.PRF(secretKey, KeysKt.getCLIENT_FINISHED_LABEL(), digest, 12);
            OutputKt.writeFully$default((Output)$this$finished_u24lambda_u244, prf, 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    @NotNull
    public static final byte[] serverFinished(@NotNull byte[] handshakeHash, @NotNull SecretKey secretKey, int length) {
        Intrinsics.checkNotNullParameter(handshakeHash, "handshakeHash");
        Intrinsics.checkNotNullParameter(secretKey, "secretKey");
        return HashesKt.PRF(secretKey, KeysKt.getSERVER_FINISHED_LABEL(), handshakeHash, length);
    }

    public static /* synthetic */ byte[] serverFinished$default(byte[] byArray, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        return RenderKt.serverFinished(byArray, secretKey, n);
    }

    public static final void writePublicKeyUncompressed(@NotNull BytePacketBuilder $this$writePublicKeyUncompressed, @NotNull PublicKey key2) {
        Intrinsics.checkNotNullParameter($this$writePublicKeyUncompressed, "<this>");
        Intrinsics.checkNotNullParameter(key2, "key");
        if (!(key2 instanceof ECPublicKey)) {
            throw new TLSException("Unsupported public key type: " + key2, null, 2, null);
        }
        int fieldSize = ((ECPublicKey)key2).getParams().getCurve().getField().getFieldSize();
        ECPoint eCPoint = ((ECPublicKey)key2).getW();
        Intrinsics.checkNotNullExpressionValue(eCPoint, "key.w");
        RenderKt.writeECPoint($this$writePublicKeyUncompressed, eCPoint, fieldSize);
    }

    public static final void writeECPoint(@NotNull BytePacketBuilder $this$writeECPoint, @NotNull ECPoint point, int fieldSize) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$writeECPoint, "<this>");
        Intrinsics.checkNotNullParameter(point, "point");
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$writeECPoint_u24lambda_u245 = builder$iv;
            boolean bl = false;
            $this$writeECPoint_u24lambda_u245.writeByte((byte)4);
            byte[] byArray = point.getAffineX().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "point.affineX.toByteArray()");
            RenderKt.writeAligned($this$writeECPoint_u24lambda_u245, byArray, fieldSize);
            byte[] byArray2 = point.getAffineY().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray2, "point.affineY.toByteArray()");
            RenderKt.writeAligned($this$writeECPoint_u24lambda_u245, byArray2, fieldSize);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket pointData = byteReadPacket;
        $this$writeECPoint.writeByte((byte)pointData.getRemaining());
        $this$writeECPoint.writePacket(pointData);
    }

    private static final ByteReadPacket buildSignatureAlgorithmsExtension(List<HashAndSign> algorithms) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$buildSignatureAlgorithmsExtension_u24lambda_u247 = builder$iv;
            boolean bl = false;
            OutputPrimitivesKt.writeShort($this$buildSignatureAlgorithmsExtension_u24lambda_u247, TLSExtensionType.SIGNATURE_ALGORITHMS.getCode());
            int size2 = algorithms.size();
            OutputPrimitivesKt.writeShort($this$buildSignatureAlgorithmsExtension_u24lambda_u247, (short)(2 + size2 * 2));
            OutputPrimitivesKt.writeShort($this$buildSignatureAlgorithmsExtension_u24lambda_u247, (short)(size2 * 2));
            Iterable $this$forEach$iv = algorithms;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HashAndSign it = (HashAndSign)element$iv;
                boolean bl2 = false;
                $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeByte(it.getHash().getCode());
                $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeByte(it.getSign().getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildSignatureAlgorithmsExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
        }
        return RenderKt.buildSignatureAlgorithmsExtension(list);
    }

    private static final ByteReadPacket buildServerNameExtension(String name) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$buildServerNameExtension_u24lambda_u249 = builder$iv;
            boolean bl = false;
            if (!(name.length() < 32762)) {
                boolean bl2 = false;
                String string = "Server name length limit exceeded: at most 32762 characters allowed";
                throw new IllegalArgumentException(string.toString());
            }
            OutputPrimitivesKt.writeShort($this$buildServerNameExtension_u24lambda_u249, TLSExtensionType.SERVER_NAME.getCode());
            OutputPrimitivesKt.writeShort($this$buildServerNameExtension_u24lambda_u249, (short)(name.length() + 2 + 1 + 2));
            OutputPrimitivesKt.writeShort($this$buildServerNameExtension_u24lambda_u249, (short)(name.length() + 2 + 1));
            $this$buildServerNameExtension_u24lambda_u249.writeByte((byte)0);
            OutputPrimitivesKt.writeShort($this$buildServerNameExtension_u24lambda_u249, (short)name.length());
            StringsKt.writeText$default((Output)$this$buildServerNameExtension_u24lambda_u249, name, 0, 0, null, 14, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    private static final ByteReadPacket buildECCurvesExtension(List<? extends NamedCurve> curves) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$buildECCurvesExtension_u24lambda_u2412 = builder$iv;
            boolean bl = false;
            if (!(curves.size() <= 16382)) {
                boolean $i$a$-require-RenderKt$buildECCurvesExtension$1$22 = false;
                String $i$a$-require-RenderKt$buildECCurvesExtension$1$22 = "Too many named curves provided: at most 16382 could be provided";
                throw new IllegalArgumentException($i$a$-require-RenderKt$buildECCurvesExtension$1$22.toString());
            }
            OutputPrimitivesKt.writeShort($this$buildECCurvesExtension_u24lambda_u2412, TLSExtensionType.ELLIPTIC_CURVES.getCode());
            int size2 = curves.size() * 2;
            OutputPrimitivesKt.writeShort($this$buildECCurvesExtension_u24lambda_u2412, (short)(2 + size2));
            OutputPrimitivesKt.writeShort($this$buildECCurvesExtension_u24lambda_u2412, (short)size2);
            Iterable $this$forEach$iv = curves;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NamedCurve it = (NamedCurve)((Object)element$iv);
                boolean bl2 = false;
                OutputPrimitivesKt.writeShort($this$buildECCurvesExtension_u24lambda_u2412, it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildECCurvesExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = NamedCurvesKt.getSupportedNamedCurves();
        }
        return RenderKt.buildECCurvesExtension(list);
    }

    private static final ByteReadPacket buildECPointFormatExtension(List<? extends PointFormat> formats) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$buildECPointFormatExtension_u24lambda_u2414 = builder$iv;
            boolean bl = false;
            OutputPrimitivesKt.writeShort($this$buildECPointFormatExtension_u24lambda_u2414, TLSExtensionType.EC_POINT_FORMAT.getCode());
            int size2 = formats.size();
            OutputPrimitivesKt.writeShort($this$buildECPointFormatExtension_u24lambda_u2414, (short)(1 + size2));
            $this$buildECPointFormatExtension_u24lambda_u2414.writeByte((byte)size2);
            Iterable $this$forEach$iv = formats;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PointFormat it = (PointFormat)((Object)element$iv);
                boolean bl2 = false;
                $this$buildECPointFormatExtension_u24lambda_u2414.writeByte(it.getCode());
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return byteReadPacket;
    }

    static /* synthetic */ ByteReadPacket buildECPointFormatExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = PointFormatKt.getSupportedPointFormats();
        }
        return RenderKt.buildECPointFormatExtension(list);
    }

    private static final void writeAligned(BytePacketBuilder $this$writeAligned, byte[] src, int fieldSize) {
        int n;
        int expectedSize;
        block2: {
            expectedSize = fieldSize + 7 >>> 3;
            byte[] $this$indexOfFirst$iv = src;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                byte it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it != 0)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int index = n;
        int padding = expectedSize - (src.length - index);
        if (padding > 0) {
            OutputKt.writeFully$default((Output)$this$writeAligned, new byte[padding], 0, 0, 6, null);
        }
        OutputKt.writeFully((Output)$this$writeAligned, src, index, src.length - index);
    }

    private static final void writeTripleByteLength(BytePacketBuilder $this$writeTripleByteLength, int value) {
        int high = value >>> 16 & 0xFF;
        int low = value & 0xFFFF;
        $this$writeTripleByteLength.writeByte((byte)high);
        OutputPrimitivesKt.writeShort($this$writeTripleByteLength, (short)low);
    }
}

